/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.client2.session;

import com.dropbox.client2.RESTUtility;
import com.dropbox.client2.exception.DropboxException;
import com.dropbox.client2.exception.DropboxParseException;
import com.dropbox.client2.session.AbstractSession;
import com.dropbox.client2.session.AccessTokenPair;
import com.dropbox.client2.session.AppKeyPair;
import com.dropbox.client2.session.RequestTokenPair;
import com.dropbox.client2.session.Session;
import java.util.Map;
import org.apache.http.HttpResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAuthSession
extends AbstractSession {
    public WebAuthSession(AppKeyPair appKeyPair, Session.AccessType accessType) {
        super(appKeyPair, accessType);
    }

    public WebAuthSession(AppKeyPair appKeyPair, Session.AccessType accessType, AccessTokenPair accessTokenPair) {
        super(appKeyPair, accessType, accessTokenPair);
    }

    public WebAuthInfo getAuthInfo() throws DropboxException {
        return this.getAuthInfo(null);
    }

    public WebAuthInfo getAuthInfo(String string) throws DropboxException {
        this.setUpToken("/oauth/request_token");
        AccessTokenPair accessTokenPair = this.getAccessTokenPair();
        RequestTokenPair requestTokenPair = new RequestTokenPair(accessTokenPair.key, accessTokenPair.secret);
        String[] stringArray = string != null ? new String[]{"oauth_token", requestTokenPair.key, "oauth_callback", string, "locale", this.getLocale().toString()} : new String[]{"oauth_token", requestTokenPair.key, "locale", this.getLocale().toString()};
        String string2 = RESTUtility.buildURL(this.getWebServer(), 1, "/oauth/authorize", stringArray);
        return new WebAuthInfo(string2, requestTokenPair);
    }

    public String retrieveWebAccessToken(RequestTokenPair requestTokenPair) throws DropboxException {
        this.setAccessTokenPair(requestTokenPair);
        Map<String, String> map = this.setUpToken("/oauth/access_token");
        return map.get("uid");
    }

    private Map<String, String> setUpToken(String string) throws DropboxException {
        HttpResponse httpResponse = RESTUtility.streamRequest((RESTUtility.RequestMethod)RESTUtility.RequestMethod.GET, (String)this.getAPIServer(), (String)string, (int)1, (String[])new String[]{"locale", this.getLocale().toString()}, (Session)this).response;
        Map<String, String> map = RESTUtility.parseAsQueryString(httpResponse);
        if (!map.containsKey("oauth_token") || !map.containsKey("oauth_token_secret")) {
            throw new DropboxParseException("Did not get tokens from Dropbox");
        }
        this.setAccessTokenPair(new AccessTokenPair(map.get("oauth_token"), map.get("oauth_token_secret")));
        return map;
    }

    public static final class WebAuthInfo {
        public final String url;
        public final RequestTokenPair requestTokenPair;

        private WebAuthInfo(String string, RequestTokenPair requestTokenPair) {
            this.url = string;
            this.requestTokenPair = requestTokenPair;
        }
    }
}

