/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.client2.jsonextract;

import com.dropbox.client2.jsonextract.JsonBase;
import com.dropbox.client2.jsonextract.JsonExtractionException;
import com.dropbox.client2.jsonextract.JsonThing;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonMap
extends JsonBase<Map<String, Object>>
implements Iterable<Map.Entry<String, JsonThing>> {
    public JsonMap(Map<String, Object> map, String string) {
        super(map, string);
    }

    public JsonMap(Map<String, Object> map) {
        super(map);
    }

    private static boolean isIdentLike(String string) {
        if (string.length() == 0) {
            return false;
        }
        if (!JsonMap.isEnglishLetter(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (JsonMap.isEnglishLetter(c) || JsonMap.isEnglishDigit(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isEnglishLetter(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    private static boolean isEnglishDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static String pathConcatField(String string, String string2) {
        String string3 = string2;
        if (!JsonMap.isIdentLike(string2)) {
            string3 = '\"' + string2 + '\"';
        }
        return JsonThing.pathConcat(string, string3);
    }

    public JsonThing get(String string) throws JsonExtractionException {
        if (!((Map)this.internal).containsKey(string)) {
            throw this.error("expecting object to have field \"" + string + "\", but it does not");
        }
        return new JsonThing(((Map)this.internal).get(string), JsonMap.pathConcatField(this.path, string));
    }

    public JsonThing getMaybe(String string) {
        if (!((Map)this.internal).containsKey(string)) {
            return null;
        }
        return new JsonThing(((Map)this.internal).get(string), JsonMap.pathConcatField(this.path, string));
    }

    @Override
    public Iterator<Map.Entry<String, JsonThing>> iterator() {
        return new WrapperIterator(this.path, ((Map)this.internal).entrySet().iterator());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WrappedEntry
    implements Map.Entry<String, JsonThing> {
        private final String key;
        private final JsonThing value;

        private WrappedEntry(String string, Map.Entry<String, Object> entry) {
            this.key = entry.getKey();
            this.value = new JsonThing(entry.getValue(), JsonMap.pathConcatField(string, this.key));
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public JsonThing getValue() {
            return this.value;
        }

        @Override
        public JsonThing setValue(JsonThing jsonThing) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WrapperIterator
    implements Iterator<Map.Entry<String, JsonThing>> {
        private final String path;
        private final Iterator<Map.Entry<String, Object>> internal;

        private WrapperIterator(String string, Iterator<Map.Entry<String, Object>> iterator) {
            this.path = string;
            this.internal = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.internal.hasNext();
        }

        @Override
        public Map.Entry<String, JsonThing> next() {
            return new WrappedEntry(this.path, this.internal.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("can't remove");
        }
    }
}

