/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.client2.exception;

import com.dropbox.client2.exception.DropboxException;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;

public class DropboxServerException
extends DropboxException {
    public static final int _200_OK = 200;
    public static final int _302_FOUND = 302;
    public static final int _304_NOT_MODIFIED = 304;
    public static final int _400_BAD_REQUEST = 400;
    public static final int _401_UNAUTHORIZED = 401;
    public static final int _403_FORBIDDEN = 403;
    public static final int _404_NOT_FOUND = 404;
    public static final int _405_METHOD_NOT_ALLOWED = 405;
    public static final int _406_NOT_ACCEPTABLE = 406;
    public static final int _409_CONFLICT = 409;
    public static final int _411_LENGTH_REQUIRED = 411;
    public static final int _415_UNSUPPORTED_MEDIA = 415;
    public static final int _500_INTERNAL_SERVER_ERROR = 500;
    public static final int _501_NOT_IMPLEMENTED = 501;
    public static final int _502_BAD_GATEWAY = 502;
    public static final int _503_SERVICE_UNAVAILABLE = 503;
    public static final int _507_INSUFFICIENT_STORAGE = 507;
    private static final long serialVersionUID = 1L;
    public Error body;
    public int error;
    public String reason;
    public String server;
    public String location;
    public Map<String, Object> parsedResponse;

    public DropboxServerException(HttpResponse httpResponse) {
        this.fillInStackTrace();
        StatusLine statusLine = httpResponse.getStatusLine();
        this.error = statusLine.getStatusCode();
        this.reason = statusLine.getReasonPhrase();
        this.server = DropboxServerException.getHeader(httpResponse, "server");
        this.location = DropboxServerException.getHeader(httpResponse, "location");
    }

    public DropboxServerException(HttpResponse httpResponse, Object object) {
        this(httpResponse);
        if (object != null && object instanceof Map) {
            this.parsedResponse = (Map)object;
            this.body = new Error(this.parsedResponse);
        }
    }

    public boolean isDuplicateAccount() {
        return this.error == 400 && this.body != null && this.body.error.contains("taken");
    }

    public String toString() {
        return "DropboxServerException (" + this.server + "): " + this.error + " " + this.reason + " (" + this.body.error + ")";
    }

    public static boolean isValidWithNullBody(HttpResponse httpResponse) {
        int n;
        String string;
        int n2 = httpResponse.getStatusLine().getStatusCode();
        return n2 == 302 ? (string = DropboxServerException.getHeader(httpResponse, "location")) != null && (n = string.indexOf("://")) > -1 && (n = (string = string.substring(n + 3)).indexOf("/")) > -1 && (string = string.substring(0, n)).toLowerCase().contains("dropbox.com") : n2 == 304;
    }

    private static String getHeader(HttpResponse httpResponse, String string) {
        String string2 = null;
        Header header = httpResponse.getFirstHeader(string);
        if (header != null) {
            string2 = header.getValue();
        }
        return string2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Error {
        public String error;
        public String userError;

        public Error(Map<String, Object> map) {
            if (map != null) {
                Object object;
                Object object2 = map.get("error");
                if (object2 instanceof String) {
                    this.error = (String)object2;
                } else if (object2 instanceof Map) {
                    object = (Map)object2;
                    for (Object v : object.values()) {
                        if (!(v instanceof String)) continue;
                        this.error = (String)v;
                    }
                }
                object = map.get("user_error");
                if (object instanceof String) {
                    this.userError = (String)object;
                }
            }
        }
    }
}

