/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.client2.android;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import com.dropbox.client2.android.AuthActivity;
import com.dropbox.client2.session.AbstractSession;
import com.dropbox.client2.session.AccessTokenPair;
import com.dropbox.client2.session.AppKeyPair;
import com.dropbox.client2.session.Session;
import java.util.List;

public class AndroidAuthSession
extends AbstractSession {
    public AndroidAuthSession(AppKeyPair appKeyPair, Session.AccessType accessType) {
        super(appKeyPair, accessType);
    }

    public AndroidAuthSession(AppKeyPair appKeyPair, Session.AccessType accessType, AccessTokenPair accessTokenPair) {
        super(appKeyPair, accessType, accessTokenPair);
    }

    public void startAuthentication(Context context) {
        AppKeyPair appKeyPair = this.getAppKeyPair();
        Intent intent = new Intent("android.intent.action.VIEW");
        String string = "db-" + appKeyPair.key;
        String string2 = string + "://" + 1 + "/test";
        intent.setData(Uri.parse((String)string2));
        PackageManager packageManager = context.getPackageManager();
        List list = packageManager.queryIntentActivities(intent, 0);
        if (0 == list.size()) {
            throw new IllegalStateException("URI scheme in your app's manifest is not set up correctly. You should have a com.dropbox.client2.android.AuthActivity with the scheme: " + string);
        }
        if (list.size() > 1) {
            AlertDialog.Builder builder = new AlertDialog.Builder(context);
            builder.setTitle((CharSequence)"Security alert");
            builder.setMessage((CharSequence)"Another app on your phone may be trying to pose as the app you are currently using. The malicious app cannot access your account, but linking to Dropbox has been disabled as a precaution. Please contact support@dropbox.com.");
            builder.setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int n) {
                    dialogInterface.dismiss();
                }
            });
            builder.show();
            return;
        }
        String string3 = ((ResolveInfo)list.get((int)0)).activityInfo.packageName;
        if (!context.getPackageName().equals(string3)) {
            throw new IllegalStateException("There must be an AuthActivity within your app's package registered for your URI scheme (" + string + "). However, it " + "appears that an activity in a different package is " + "registered for that scheme instead. If you have " + "multiple apps that all want to use the same access" + "token pair, designate one of them to do " + "authentication and have the other apps launch it " + "and then retrieve the token pair from it.");
        }
        string3 = new Intent(context, AuthActivity.class);
        string3.putExtra("EXTRA_INTERNAL_CONSUMER_KEY", appKeyPair.key);
        string3.putExtra("EXTRA_INTERNAL_CONSUMER_SECRET", appKeyPair.secret);
        if (!(context instanceof Activity)) {
            string3.addFlags(0x10000000);
        }
        context.startActivity((Intent)string3);
    }

    public boolean authenticationSuccessful() {
        Intent intent = AuthActivity.lastResult;
        if (intent == null) {
            return false;
        }
        String string = intent.getStringExtra("ACCESS_TOKEN");
        String string2 = intent.getStringExtra("ACCESS_SECRET");
        String string3 = intent.getStringExtra("UID");
        return string != null && !string.equals("") && string2 != null && !string2.equals("") && string3 != null && !string3.equals("");
    }

    public String finishAuthentication() throws IllegalStateException {
        Intent intent = AuthActivity.lastResult;
        if (intent == null) {
            throw new IllegalStateException();
        }
        String string = intent.getStringExtra("ACCESS_TOKEN");
        String string2 = intent.getStringExtra("ACCESS_SECRET");
        String string3 = intent.getStringExtra("UID");
        if (!(string == null || string.equals("") || string2 == null || string2.equals("") || string3 == null || string3.equals(""))) {
            AccessTokenPair accessTokenPair = new AccessTokenPair(string, string2);
            this.setAccessTokenPair(accessTokenPair);
            return string3;
        }
        throw new IllegalStateException();
    }

    public void unlink() {
        super.unlink();
        AuthActivity.lastResult = null;
    }
}

