/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.client2;

import com.dropbox.client2.DropboxAPI;
import com.dropbox.client2.exception.DropboxException;
import com.dropbox.client2.exception.DropboxIOException;
import com.dropbox.client2.exception.DropboxParseException;
import com.dropbox.client2.exception.DropboxSSLException;
import com.dropbox.client2.exception.DropboxServerException;
import com.dropbox.client2.exception.DropboxUnlinkedException;
import com.dropbox.client2.session.Session;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import javax.net.ssl.SSLException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RESTUtility {
    private static final DateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy kk:mm:ss ZZZZZ", Locale.US);

    private RESTUtility() {
    }

    public static Object request(RequestMethod requestMethod, String string, String string2, int n, String[] stringArray, Session session) throws DropboxException {
        HttpResponse httpResponse = RESTUtility.streamRequest((RequestMethod)requestMethod, (String)string, (String)string2, (int)n, (String[])stringArray, (Session)session).response;
        return RESTUtility.parseAsJSON(httpResponse);
    }

    public static DropboxAPI.RequestAndResponse streamRequest(RequestMethod requestMethod, String string, String string2, int n, String[] stringArray, Session session) throws DropboxException {
        HttpPost httpPost;
        HttpGet httpGet = null;
        String string3 = null;
        if (requestMethod == RequestMethod.GET) {
            string3 = RESTUtility.buildURL(string, n, string2, stringArray);
            httpGet = new HttpGet(string3);
        } else {
            string3 = RESTUtility.buildURL(string, n, string2, null);
            httpPost = new HttpPost(string3);
            if (stringArray != null && stringArray.length >= 2) {
                if (stringArray.length % 2 != 0) {
                    throw new IllegalArgumentException("Params must have an even number of elements.");
                }
                ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>();
                for (int i = 0; i < stringArray.length; i += 2) {
                    if (stringArray[i + 1] == null) continue;
                    arrayList.add(new BasicNameValuePair(stringArray[i], stringArray[i + 1]));
                }
                try {
                    httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(arrayList, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new DropboxException(unsupportedEncodingException);
                }
            }
            httpGet = httpPost;
        }
        session.sign((HttpRequest)httpGet);
        httpPost = RESTUtility.execute(session, (HttpUriRequest)httpGet);
        return new DropboxAPI.RequestAndResponse((HttpUriRequest)httpGet, (HttpResponse)httpPost);
    }

    public static Object parseAsJSON(HttpResponse httpResponse) throws DropboxException {
        Object object = null;
        BufferedReader bufferedReader = null;
        try {
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity != null) {
                InputStreamReader inputStreamReader = new InputStreamReader(httpEntity.getContent());
                bufferedReader = new BufferedReader(inputStreamReader, 16384);
                bufferedReader.mark(16384);
                JSONParser jSONParser = new JSONParser();
                object = jSONParser.parse((Reader)bufferedReader);
            }
        }
        catch (IOException iOException) {
            throw new DropboxIOException(iOException);
        }
        catch (ParseException parseException) {
            if (DropboxServerException.isValidWithNullBody(httpResponse)) {
                throw new DropboxServerException(httpResponse);
            }
            throw new DropboxParseException(bufferedReader);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new DropboxException(outOfMemoryError);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        int n = httpResponse.getStatusLine().getStatusCode();
        if (n != 200) {
            if (n == 401) {
                throw new DropboxUnlinkedException();
            }
            throw new DropboxServerException(httpResponse, object);
        }
        return object;
    }

    public static Map<String, String> parseAsQueryString(HttpResponse httpResponse) throws DropboxException {
        Scanner scanner;
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity == null) {
            throw new DropboxParseException("Bad response from Dropbox.");
        }
        try {
            scanner = new Scanner(httpEntity.getContent()).useDelimiter("&");
        }
        catch (IOException iOException) {
            throw new DropboxIOException(iOException);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (scanner.hasNext()) {
            String string = scanner.next();
            String[] stringArray = string.split("=");
            if (stringArray.length != 2) {
                throw new DropboxParseException("Bad query string from Dropbox.");
            }
            hashMap.put(stringArray[0], stringArray[1]);
        }
        return hashMap;
    }

    public static HttpResponse execute(Session session, HttpUriRequest httpUriRequest) throws DropboxException {
        return RESTUtility.execute(session, httpUriRequest, -1);
    }

    public static HttpResponse execute(Session session, HttpUriRequest httpUriRequest, int n) throws DropboxException {
        HttpParams httpParams;
        HttpClient httpClient = RESTUtility.updatedHttpClient(session);
        session.setRequestTimeout(httpUriRequest);
        if (n >= 0) {
            httpParams = httpUriRequest.getParams();
            HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)n);
        }
        try {
            httpParams = null;
            for (int i = 0; httpParams == null && i < 5; ++i) {
                try {
                    httpParams = httpClient.execute(httpUriRequest);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                if (httpParams != null) continue;
                RESTUtility.updateClientProxy(httpClient, session);
            }
            if (httpParams == null) {
                throw new DropboxIOException("Apache HTTPClient encountered an error. No response, try again.");
            }
            if (httpParams.getStatusLine().getStatusCode() != 200) {
                RESTUtility.parseAsJSON((HttpResponse)httpParams);
            }
            return httpParams;
        }
        catch (SSLException sSLException) {
            throw new DropboxSSLException(sSLException);
        }
        catch (IOException iOException) {
            throw new DropboxIOException(iOException);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new DropboxException(outOfMemoryError);
        }
    }

    public static String buildURL(String string, int n, String string2, String[] stringArray) {
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        try {
            string2 = URLEncoder.encode("/" + n + string2, "UTF-8");
            string2 = string2.replace("%2F", "/");
            if (stringArray != null && stringArray.length > 0) {
                string2 = string2 + "?" + RESTUtility.urlencode(stringArray);
            }
            string2 = string2.replace("+", "%20").replace("*", "%2A");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
        return "https://" + string + ":443" + string2;
    }

    public static Date parseDate(String string) {
        try {
            return dateFormat.parse(string);
        }
        catch (java.text.ParseException parseException) {
            return null;
        }
    }

    private static synchronized HttpClient updatedHttpClient(Session session) {
        HttpClient httpClient = session.getHttpClient();
        RESTUtility.updateClientProxy(httpClient, session);
        return httpClient;
    }

    private static void updateClientProxy(HttpClient httpClient, Session session) {
        Session.ProxyInfo proxyInfo = session.getProxyInfo();
        if (proxyInfo != null && proxyInfo.host != null && !proxyInfo.host.equals("")) {
            HttpHost httpHost = proxyInfo.port < 0 ? new HttpHost(proxyInfo.host) : new HttpHost(proxyInfo.host, proxyInfo.port);
            httpClient.getParams().setParameter("http.route.default-proxy", (Object)httpHost);
        } else {
            httpClient.getParams().removeParameter("http.route.default-proxy");
        }
    }

    private static String urlencode(String[] stringArray) {
        if (stringArray.length % 2 != 0) {
            throw new IllegalArgumentException("Params must have an even number of elements.");
        }
        String string = "";
        try {
            boolean bl = true;
            for (int i = 0; i < stringArray.length; i += 2) {
                if (stringArray[i + 1] == null) continue;
                if (bl) {
                    bl = false;
                } else {
                    string = string + "&";
                }
                string = string + URLEncoder.encode(stringArray[i], "UTF-8") + "=" + URLEncoder.encode(stringArray[i + 1], "UTF-8");
            }
            string.replace("*", "%2A");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
        return string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RequestMethod {
        GET,
        POST;

    }
}

