/*
 * xvii - messenger for vk
 * Copyright (C) 2021  TwoEightNine
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package global.msnthrp.xvii.data.accounts

import androidx.room.*
import io.reactivex.Completable

@Dao
interface AccountsDao {

    @Query("SELECT * FROM accounts")
    fun getAccounts(): List<AccountEntity>

    @Query("SELECT * FROM accounts ORDER BY isRunning DESC")
    fun getAccountsRunningFirst(): List<AccountEntity>

    @Query("SELECT * FROM accounts WHERE isRunning = 1 LIMIT 1")
    fun getRunningAccount(): AccountEntity

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    fun insertAccount(account: AccountEntity)

    @Delete
    fun deleteAccount(account: AccountEntity): Int

    @Query("DELETE FROM accounts WHERE token = :token")
    fun deleteByToken(token: String): Completable

}