/*
 * xvii - messenger for vk
 * Copyright (C) 2021  TwoEightNine
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package com.twoeightnine.root.xvii.uikit

import android.content.Context
import android.content.res.ColorStateList
import android.graphics.Color
import android.util.AttributeSet
import androidx.core.content.ContextCompat
import com.google.android.material.floatingactionbutton.FloatingActionButton
import com.twoeightnine.root.xvii.R
import com.twoeightnine.root.xvii.managers.Prefs

class XviiFab(context: Context, attributeSet: AttributeSet) : FloatingActionButton(context, attributeSet) {

    init {
        backgroundTintList = ColorStateList.valueOf(Munch.color.color)
        val iconColor = when {
            Prefs.colorBetterWithWhite -> Color.WHITE
            else -> ContextCompat.getColor(context, R.color.main_text_light)
        }
        drawable.paint(iconColor)
    }

}