import 'package:audio_picker/audio_picker.dart';
import 'package:mighty_plug_manager/platform/platformUtils.dart';

class SourceResolver {
  static final Map<String, String> _pathCache = {};
  static Future<String> getSourceUrl(String sourceUri) async {
    if (sourceUri.startsWith("yt:")) {







    }
    else if (sourceUri.startsWith("iosbm:")) {
      var url = await AudioPicker().iosBookmarkToUrl(sourceUri);
      return url;
    }
    return sourceUri;
  }

  static void releaseUrl(String sourceUrl, String resolvedUrl) {
    if (PlatformUtils.isIOS) {
      if (sourceUrl.startsWith("iosbm:")) {
        AudioPicker().iosReleaseSecurityScope(resolvedUrl);
        return;
      }
    }
  }

  static void addToCache(String id, String url) {
    _pathCache[id] = url;
  }

  static String? getFromCache(String id) {
    return _pathCache[id];
  }
}
