<div align="center">

<!-- ---------- Header ---------- -->
<img src="./docs/featured.png">
<!-- Original background with CC0 from https://www.maxpixel.net/Digital-Network-Internet-Communication-Connections-3537400 -->

<!-- title -->

# URLCheck

<!-- ---------- Badges ---------- -->
[![App-Code Size](https://img.shields.io/github/languages/code-size/trianguloy/urlchecker.svg)](https://api.github.com/repos/TrianguloY/URLCheck)
[![GitHub commit activity](https://img.shields.io/github/commit-activity/m/TrianguloY/URLCheck)](https://github.com/TrianguloY/URLCheck/pulse/monthly)
[![Weblate (translation percentage)](https://hosted.weblate.org/widgets/urlcheck/-/svg-badge.svg)](https://hosted.weblate.org/engage/urlcheck/)
[![Development version](https://img.shields.io/badge/dynamic/regex?url=https%3A%2F%2Fraw.githubusercontent.com%2FTrianguloY%2FURLCheck%2Frefs%2Fheads%2Fmaster%2Fapp%2Fbuild.gradle&search=versionName%20%5B%27%22%5D(.*)%5B%27%22%5D&replace=v%241&label=development%20version&color=darkgrey)](https://github.com/TrianguloY/URLCheck/blob/master/app/build.gradle)

[![GitHub version](https://img.shields.io/github/v/release/TrianguloY/URLCheck?logo=github&label=Github%20version&color=white)](https://github.com/TrianguloY/URLCheck/releases)
[![F-Droid version](https://img.shields.io/f-droid/v/com.trianguloy.urlchecker?label=F-Droid%20version&logo=fdroid&color=%231e79d3)](https://gitlab.com/fdroid/fdroiddata/-/blob/master/metadata/com.trianguloy.urlchecker.yml)
[![Play Store version](https://img.shields.io/endpoint?color=green&logo=googleplay&url=https%3A%2F%2Fplay.cuzi.workers.dev%2Fplay%3Fi%3Dcom.trianguloy.urlchecker%26l%3DPlay%2520Store%2520version%26m%3Dv%24version)](https://play.google.com/store/apps/details?id=com.trianguloy.urlchecker)
[![IzzyOnDroid version](https://img.shields.io/badge/dynamic/json?url=https%3A%2F%2Fapt.izzysoft.de%2Ffdroid%2Fapi%2Fv1%2Fshield%2Fcom.trianguloy.urlchecker&query=message&prefix=v&logo=data%3Aimage%2Fsvg%2Bxml%3Bbase64%2CPD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0idXRmLTgiPz48IS0tIFVwbG9hZGVkIHRvOiBTVkcgUmVwbywgd3d3LnN2Z3JlcG8uY29tLCBHZW5lcmF0b3I6IFNWRyBSZXBvIE1peGVyIFRvb2xzIC0tPgo8c3ZnIHdpZHRoPSIxMDBweCIgaGVpZ2h0PSIxMDBweCIgdmlld0JveD0iMCAwIDQ4IDQ4IiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciPjxwYXRoIGZpbGw9IiNGRkZGRkYiIGNsYXNzPSJhIiBkPSJtMTkuMjU2IDI0LjA4Ni0xLjYzNy0xLjczMUwxOCAyMmwxLjY3NSAxLjc0OG00LjY2Ni4wMTRMMjYgMjJsLjM3MS4zNjItMS42NTkgMS42OThNMTcgNDNoMTJjOSAwIDE3LTE4IDQtMjR6TTMgNDNoMTNsMTYtMjRIMTltLTkgMTJDLTMgMjcgMyA2IDE4IDZoOXptMjMtMTNIMjBsOC0xMmgxM3ptLTE1IDlhNCA0IDAgMDE4IDB6bTUuNDk2LTIuNWEuNzUyLjc1MiAwIDEwLjAwNCAwem0tMyAwYS43NS43NSAwIDEwLjAwNCAweiIvPjwvc3ZnPg%3D%3D&label=IzzyOnDroid%20version&color=%2300d3ff)](https://apt.izzysoft.de/fdroid/index/apk/com.trianguloy.urlchecker)

<!-- ---------- Download ---------- -->
[<img src="./docs/badge_github.png"
alt="Get it on GitHub"
height="80">](https://github.com/TrianguloY/URLCheck/releases/latest/)
[<img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png"
alt="Get it on F-Droid"
height="80">](https://f-droid.org/packages/com.trianguloy.urlchecker)
[<img src="https://play.google.com/intl/en_us/badges/images/generic/en-play-badge.png"
alt="Get it on Google Play"
height="80">](https://play.google.com/store/apps/details?id=com.trianguloy.urlchecker)
[<img src="https://gitlab.com/IzzyOnDroid/repo/-/raw/master/assets/IzzyOnDroid.png"
alt="Get it on IzzyOnDroid"
height="80">](https://apt.izzysoft.de/fdroid/index/apk/com.trianguloy.urlchecker)
[<img src="https://github.com/user-attachments/assets/713d71c5-3dec-4ec4-a3f2-8d28d025a9c6"
alt="Get it on Obtainium"
height="80">](https://apps.obtainium.imranr.dev/redirect?r=obtainium://app/%7B%22id%22%3A%22com.trianguloy.urlchecker%22%2C%22url%22%3A%22https%3A%2F%2Fgithub.com%2FTrianguloY%2FURLCheck%22%2C%22author%22%3A%22TrianguloY%22%2C%22name%22%3A%22URLCheck%22%2C%22preferredApkIndex%22%3A0%2C%22additionalSettings%22%3A%22%7B%5C%22includePrereleases%5C%22%3Afalse%2C%5C%22fallbackToOlderReleases%5C%22%3Atrue%2C%5C%22filterReleaseTitlesByRegEx%5C%22%3A%5C%22%5C%22%2C%5C%22filterReleaseNotesByRegEx%5C%22%3A%5C%22%5C%22%2C%5C%22verifyLatestTag%5C%22%3Afalse%2C%5C%22dontSortReleasesList%5C%22%3Afalse%2C%5C%22useLatestAssetDateAsReleaseDate%5C%22%3Afalse%2C%5C%22releaseTitleAsVersion%5C%22%3Afalse%2C%5C%22trackOnly%5C%22%3Afalse%2C%5C%22versionExtractionRegEx%5C%22%3A%5C%22%5C%22%2C%5C%22matchGroupToUse%5C%22%3A%5C%22%5C%22%2C%5C%22versionDetection%5C%22%3Atrue%2C%5C%22releaseDateAsVersion%5C%22%3Afalse%2C%5C%22useVersionCodeAsOSVersion%5C%22%3Afalse%2C%5C%22apkFilterRegEx%5C%22%3A%5C%22%5C%22%2C%5C%22invertAPKFilter%5C%22%3Afalse%2C%5C%22autoApkFilterByArch%5C%22%3Atrue%2C%5C%22appName%5C%22%3A%5C%22%5C%22%2C%5C%22shizukuPretendToBeGooglePlay%5C%22%3Afalse%2C%5C%22allowInsecure%5C%22%3Afalse%2C%5C%22exemptFromBackgroundUpdates%5C%22%3Afalse%2C%5C%22skipUpdateNotifications%5C%22%3Afalse%2C%5C%22about%5C%22%3A%5C%22%5C%22%2C%5C%22refreshBeforeDownload%5C%22%3Afalse%7D%22%2C%22overrideSource%22%3Anull%7D)


<details><summary>Apk details</summary>

App package: `com.trianguloy.urlchecker`

SHA-256 Hash of Signing Certificate:\
Play Store: `F9:A2:D8:D8:94:FA:FE:A1:4C:F6:05:C4:D7:22:AF:D0:49:4D:69:41:1F:60:6A:AA:0B:B1:F2:85:E7:A9:A6:60`\
F-Droid: `93:D7:9B:1E:72:D5:A6:B0:BC:68:11:B9:BC:0A:83:18:1C:35:10:D5:8C:11:57:11:40:FF:3F:8A:63:F2:21:74`\
GitHub/Obtainium/IzzyOnDroid: `BF:1B:69:C1:4D:A2:42:0C:A7:20:11:F7:2C:F4:83:74:58:EC:5D:3C:C4:B5:38:24:34:37:BC:17:C1:92:01:C6`

Note: All three different versions (Play Store, F-droid and Github) are signed with different certificates, so you cannot update one with another unless you uninstall first.\
Remember to use the backup/restore functionality to migrate your data!
</details>

<hr width="75%">

<!-- contributors -->

### Android app made by [TrianguloY](https://github.com/TrianguloY)

Special contributors: [Ilithy](https://github.com/Ilithy), [PabloOQ](https://github.com/PabloOQ), [anoop-b](https://github.com/anoop-b)

All contributors: \
[![Contributors](https://contrib.rocks/image?repo=TrianguloY/URLCheck&anon=1)](https://github.com/TrianguloY/URLCheck/graphs/contributors) \
and [404potato](https://github.com/404potato) and maybe some more from [Weblate](https://hosted.weblate.org/engage/urlcheck/).

<hr>

<!-- ---------- Description ---------- -->
**URLCheck** acts as an amazingly customizable and powerful intermediary when opening url links, allowing, among other things:
to remove trackers, affiliate links, unnecessary elements, check Hosts, facilitating link holding and sharing, protecting against certain phishing techniques and many more...


<!-- ---------- Screenshots ---------- -->
<div style="display: flex;">
  <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/1-title.png" width=30%>
  <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/2-dialog.png" width=30%>
  <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/3-dialog.png" width=30%>
  <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/4-modules.png" width=30%>
  <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/5-modules.png" width=30%>
  <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/6-modules.png" width=30%>
  <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/7-modules.png" width=30%>
  <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/8-settings.png" width=30%>
</div>

</div>

<!-- ---------- Trademarks ---------- -->

Uses:

- [VirusTotal](https://www.virustotal.com/gui/)™ is a trademark of Google, Inc
- Built-in catalog copied from [ClearURLs](https://docs.clearurls.xyz/latest/specs/rules)
- [unshorten.me](https://unshorten.me/) free API by Unshorten.me
- [StevenBlack's Hosts](https://github.com/StevenBlack/hosts)

<!-- ---------- Contribution & contributors ---------- -->

## Contribution

**All help is greatly welcomed!**  
Feel free to [**suggest changes**](https://github.com/TrianguloY/URLCheck/issues/new), request a [**new feature**](https://github.com/TrianguloY/URLCheck/issues/new?assignees=&labels=enhancement&template=feature_request.md&title=), create [**bug report**](https://github.com/TrianguloY/URLCheck/issues/new?assignees=&labels=bug&template=bug_report.md&title=) or even [**pull request**](https://help.github.com/articles/about-pull-requests/). _(from a simple typo fix to a full new module or even more!)_  
**Translations are also greatly appreciated.**

See [CONTRIBUTING](docs/CONTRIBUTING.md) for code or translation details and tips.

[![Weblate (translation details)](https://hosted.weblate.org/widgets/urlcheck/-/multi-auto.svg)](https://hosted.weblate.org/engage/urlcheck/)

<a href="https://star-history.com/#TrianguloY/URLCheck&Date">
 <picture>
   <source media="(prefers-color-scheme: dark)" srcset="https://api.star-history.com/svg?repos=TrianguloY/URLCheck&type=Date&theme=dark" />
   <source media="(prefers-color-scheme: light)" srcset="https://api.star-history.com/svg?repos=TrianguloY/URLCheck&type=Date" />
   <img alt="Star History Chart" src="https://api.star-history.com/svg?repos=TrianguloY/URLCheck&type=Date" />
 </picture>
</a>

<!-- ---------- License ---------- -->

## License

<div align="center">

[<img src="https://mirrors.creativecommons.org/presskit/buttons/88x31/png/by.png"
alt="Creative Commons Attribution 4.0 International"
height="40">](http://creativecommons.org/licenses/by/4.0/)

</div>

You can use parts of this project in your own ones, or upload modified versions of it AS LONG AS you credit me.

**How to credit:**

- You must add my nick [**TrianguloY**](https://github.com/TrianguloY/) in an `about` or `acknowledgments` section visible to the user.
- You must add a link to this [**GitHub main page**](https://github.com/TrianguloY/URLCheck) or subpage (if you used a part of the code or an asset) in an `about` or `acknowledgments` section visible to the user.
