###############################################################################
# @generated
# DO NOT MODIFY: This file is auto-generated by a crate_universe tool. To
# regenerate this file, run the following:
#
#     bazel run @@//third-party:vendor
###############################################################################
"""
# `crates_repository` API

- [aliases](#aliases)
- [crate_deps](#crate_deps)
- [all_crate_deps](#all_crate_deps)
- [crate_repositories](#crate_repositories)

"""

load("@bazel_skylib//lib:selects.bzl", "selects")
load("@bazel_tools//tools/build_defs/repo:http.bzl", "http_archive")
load("@bazel_tools//tools/build_defs/repo:utils.bzl", "maybe")

###############################################################################
# MACROS API
###############################################################################

# An identifier that represent common dependencies (unconditional).
_COMMON_CONDITION = ""

def _flatten_dependency_maps(all_dependency_maps):
    """Flatten a list of dependency maps into one dictionary.

    Dependency maps have the following structure:

    ```python
    DEPENDENCIES_MAP = {
        # The first key in the map is a Bazel package
        # name of the workspace this file is defined in.
        "workspace_member_package": {

            # Not all dependencies are supported for all platforms.
            # the condition key is the condition required to be true
            # on the host platform.
            "condition": {

                # An alias to a crate target.     # The label of the crate target the
                # Aliases are only crate names.   # package name refers to.
                "package_name":                   "@full//:label",
            }
        }
    }
    ```

    Args:
        all_dependency_maps (list): A list of dicts as described above

    Returns:
        dict: A dictionary as described above
    """
    dependencies = {}

    for workspace_deps_map in all_dependency_maps:
        for pkg_name, conditional_deps_map in workspace_deps_map.items():
            if pkg_name not in dependencies:
                non_frozen_map = dict()
                for key, values in conditional_deps_map.items():
                    non_frozen_map.update({key: dict(values.items())})
                dependencies.setdefault(pkg_name, non_frozen_map)
                continue

            for condition, deps_map in conditional_deps_map.items():
                # If the condition has not been recorded, do so and continue
                if condition not in dependencies[pkg_name]:
                    dependencies[pkg_name].setdefault(condition, dict(deps_map.items()))
                    continue

                # Alert on any miss-matched dependencies
                inconsistent_entries = []
                for crate_name, crate_label in deps_map.items():
                    existing = dependencies[pkg_name][condition].get(crate_name)
                    if existing and existing != crate_label:
                        inconsistent_entries.append((crate_name, existing, crate_label))
                    dependencies[pkg_name][condition].update({crate_name: crate_label})

    return dependencies

def crate_deps(deps, package_name = None):
    """Finds the fully qualified label of the requested crates for the package where this macro is called.

    Args:
        deps (list): The desired list of crate targets.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()`.

    Returns:
        list: A list of labels to generated rust targets (str)
    """

    if not deps:
        return []

    if package_name == None:
        package_name = native.package_name()

    # Join both sets of dependencies
    dependencies = _flatten_dependency_maps([
        _NORMAL_DEPENDENCIES,
        _NORMAL_DEV_DEPENDENCIES,
        _PROC_MACRO_DEPENDENCIES,
        _PROC_MACRO_DEV_DEPENDENCIES,
        _BUILD_DEPENDENCIES,
        _BUILD_PROC_MACRO_DEPENDENCIES,
    ]).pop(package_name, {})

    # Combine all conditional packages so we can easily index over a flat list
    # TODO: Perhaps this should actually return select statements and maintain
    # the conditionals of the dependencies
    flat_deps = {}
    for deps_set in dependencies.values():
        for crate_name, crate_label in deps_set.items():
            flat_deps.update({crate_name: crate_label})

    missing_crates = []
    crate_targets = []
    for crate_target in deps:
        if crate_target not in flat_deps:
            missing_crates.append(crate_target)
        else:
            crate_targets.append(flat_deps[crate_target])

    if missing_crates:
        fail("Could not find crates `{}` among dependencies of `{}`. Available dependencies were `{}`".format(
            missing_crates,
            package_name,
            dependencies,
        ))

    return crate_targets

def all_crate_deps(
        normal = False,
        normal_dev = False,
        proc_macro = False,
        proc_macro_dev = False,
        build = False,
        build_proc_macro = False,
        package_name = None):
    """Finds the fully qualified label of all requested direct crate dependencies \
    for the package where this macro is called.

    If no parameters are set, all normal dependencies are returned. Setting any one flag will
    otherwise impact the contents of the returned list.

    Args:
        normal (bool, optional): If True, normal dependencies are included in the
            output list.
        normal_dev (bool, optional): If True, normal dev dependencies will be
            included in the output list..
        proc_macro (bool, optional): If True, proc_macro dependencies are included
            in the output list.
        proc_macro_dev (bool, optional): If True, dev proc_macro dependencies are
            included in the output list.
        build (bool, optional): If True, build dependencies are included
            in the output list.
        build_proc_macro (bool, optional): If True, build proc_macro dependencies are
            included in the output list.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()` when unset.

    Returns:
        list: A list of labels to generated rust targets (str)
    """

    if package_name == None:
        package_name = native.package_name()

    # Determine the relevant maps to use
    all_dependency_maps = []
    if normal:
        all_dependency_maps.append(_NORMAL_DEPENDENCIES)
    if normal_dev:
        all_dependency_maps.append(_NORMAL_DEV_DEPENDENCIES)
    if proc_macro:
        all_dependency_maps.append(_PROC_MACRO_DEPENDENCIES)
    if proc_macro_dev:
        all_dependency_maps.append(_PROC_MACRO_DEV_DEPENDENCIES)
    if build:
        all_dependency_maps.append(_BUILD_DEPENDENCIES)
    if build_proc_macro:
        all_dependency_maps.append(_BUILD_PROC_MACRO_DEPENDENCIES)

    # Default to always using normal dependencies
    if not all_dependency_maps:
        all_dependency_maps.append(_NORMAL_DEPENDENCIES)

    dependencies = _flatten_dependency_maps(all_dependency_maps).pop(package_name, None)

    if not dependencies:
        if dependencies == None:
            fail("Tried to get all_crate_deps for package " + package_name + " but that package had no Cargo.toml file")
        else:
            return []

    crate_deps = list(dependencies.pop(_COMMON_CONDITION, {}).values())
    for condition, deps in dependencies.items():
        crate_deps += selects.with_or({
            tuple(_CONDITIONS[condition]): deps.values(),
            "//conditions:default": [],
        })

    return crate_deps

def aliases(
        normal = False,
        normal_dev = False,
        proc_macro = False,
        proc_macro_dev = False,
        build = False,
        build_proc_macro = False,
        package_name = None):
    """Produces a map of Crate alias names to their original label

    If no dependency kinds are specified, `normal` and `proc_macro` are used by default.
    Setting any one flag will otherwise determine the contents of the returned dict.

    Args:
        normal (bool, optional): If True, normal dependencies are included in the
            output list.
        normal_dev (bool, optional): If True, normal dev dependencies will be
            included in the output list..
        proc_macro (bool, optional): If True, proc_macro dependencies are included
            in the output list.
        proc_macro_dev (bool, optional): If True, dev proc_macro dependencies are
            included in the output list.
        build (bool, optional): If True, build dependencies are included
            in the output list.
        build_proc_macro (bool, optional): If True, build proc_macro dependencies are
            included in the output list.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()` when unset.

    Returns:
        dict: The aliases of all associated packages
    """
    if package_name == None:
        package_name = native.package_name()

    # Determine the relevant maps to use
    all_aliases_maps = []
    if normal:
        all_aliases_maps.append(_NORMAL_ALIASES)
    if normal_dev:
        all_aliases_maps.append(_NORMAL_DEV_ALIASES)
    if proc_macro:
        all_aliases_maps.append(_PROC_MACRO_ALIASES)
    if proc_macro_dev:
        all_aliases_maps.append(_PROC_MACRO_DEV_ALIASES)
    if build:
        all_aliases_maps.append(_BUILD_ALIASES)
    if build_proc_macro:
        all_aliases_maps.append(_BUILD_PROC_MACRO_ALIASES)

    # Default to always using normal aliases
    if not all_aliases_maps:
        all_aliases_maps.append(_NORMAL_ALIASES)
        all_aliases_maps.append(_PROC_MACRO_ALIASES)

    aliases = _flatten_dependency_maps(all_aliases_maps).pop(package_name, None)

    if not aliases:
        return dict()

    common_items = aliases.pop(_COMMON_CONDITION, {}).items()

    # If there are only common items in the dictionary, immediately return them
    if not len(aliases.keys()) == 1:
        return dict(common_items)

    # Build a single select statement where each conditional has accounted for the
    # common set of aliases.
    crate_aliases = {"//conditions:default": dict(common_items)}
    for condition, deps in aliases.items():
        condition_triples = _CONDITIONS[condition]
        for triple in condition_triples:
            if triple in crate_aliases:
                crate_aliases[triple].update(deps)
            else:
                crate_aliases.update({triple: dict(deps.items() + common_items)})

    return select(crate_aliases)

###############################################################################
# WORKSPACE MEMBER DEPS AND ALIASES
###############################################################################

_NORMAL_DEPENDENCIES = {
    "third-party": {
        _COMMON_CONDITION: {
            "cc": Label("@vendor//:cc-1.2.46"),
            "clap": Label("@vendor//:clap-4.5.53"),
            "codespan-reporting": Label("@vendor//:codespan-reporting-0.13.1"),
            "foldhash": Label("@vendor//:foldhash-0.2.0"),
            "indexmap": Label("@vendor//:indexmap-2.12.1"),
            "proc-macro2": Label("@vendor//:proc-macro2-1.0.103"),
            "quote": Label("@vendor//:quote-1.0.42"),
            "scratch": Label("@vendor//:scratch-1.0.9"),
            "serde": Label("@vendor//:serde-1.0.228"),
            "syn": Label("@vendor//:syn-2.0.110"),
        },
    },
}

_NORMAL_ALIASES = {
    "third-party": {
        _COMMON_CONDITION: {
        },
    },
}

_NORMAL_DEV_DEPENDENCIES = {
    "third-party": {
    },
}

_NORMAL_DEV_ALIASES = {
    "third-party": {
    },
}

_PROC_MACRO_DEPENDENCIES = {
    "third-party": {
        _COMMON_CONDITION: {
            "rustversion": Label("@vendor//:rustversion-1.0.22"),
        },
    },
}

_PROC_MACRO_ALIASES = {
    "third-party": {
    },
}

_PROC_MACRO_DEV_DEPENDENCIES = {
    "third-party": {
    },
}

_PROC_MACRO_DEV_ALIASES = {
    "third-party": {
    },
}

_BUILD_DEPENDENCIES = {
    "third-party": {
    },
}

_BUILD_ALIASES = {
    "third-party": {
    },
}

_BUILD_PROC_MACRO_DEPENDENCIES = {
    "third-party": {
    },
}

_BUILD_PROC_MACRO_ALIASES = {
    "third-party": {
    },
}

_CONDITIONS = {
    "aarch64-apple-darwin": ["@rules_rust//rust/platform:aarch64-apple-darwin"],
    "aarch64-apple-ios": ["@rules_rust//rust/platform:aarch64-apple-ios"],
    "aarch64-apple-ios-sim": ["@rules_rust//rust/platform:aarch64-apple-ios-sim"],
    "aarch64-linux-android": ["@rules_rust//rust/platform:aarch64-linux-android"],
    "aarch64-pc-windows-msvc": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc"],
    "aarch64-unknown-fuchsia": ["@rules_rust//rust/platform:aarch64-unknown-fuchsia"],
    "aarch64-unknown-linux-gnu": ["@rules_rust//rust/platform:aarch64-unknown-linux-gnu"],
    "aarch64-unknown-nixos-gnu": ["@rules_rust//rust/platform:aarch64-unknown-nixos-gnu"],
    "aarch64-unknown-nto-qnx710": ["@rules_rust//rust/platform:aarch64-unknown-nto-qnx710"],
    "aarch64-unknown-uefi": ["@rules_rust//rust/platform:aarch64-unknown-uefi"],
    "arm-unknown-linux-gnueabi": ["@rules_rust//rust/platform:arm-unknown-linux-gnueabi"],
    "armv7-linux-androideabi": ["@rules_rust//rust/platform:armv7-linux-androideabi"],
    "armv7-unknown-linux-gnueabi": ["@rules_rust//rust/platform:armv7-unknown-linux-gnueabi"],
    "cfg(any())": [],
    "cfg(windows)": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc", "@rules_rust//rust/platform:i686-pc-windows-msvc", "@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "i686-apple-darwin": ["@rules_rust//rust/platform:i686-apple-darwin"],
    "i686-linux-android": ["@rules_rust//rust/platform:i686-linux-android"],
    "i686-pc-windows-msvc": ["@rules_rust//rust/platform:i686-pc-windows-msvc"],
    "i686-unknown-freebsd": ["@rules_rust//rust/platform:i686-unknown-freebsd"],
    "i686-unknown-linux-gnu": ["@rules_rust//rust/platform:i686-unknown-linux-gnu"],
    "powerpc-unknown-linux-gnu": ["@rules_rust//rust/platform:powerpc-unknown-linux-gnu"],
    "riscv32imc-unknown-none-elf": ["@rules_rust//rust/platform:riscv32imc-unknown-none-elf"],
    "riscv64gc-unknown-linux-gnu": ["@rules_rust//rust/platform:riscv64gc-unknown-linux-gnu"],
    "riscv64gc-unknown-none-elf": ["@rules_rust//rust/platform:riscv64gc-unknown-none-elf"],
    "s390x-unknown-linux-gnu": ["@rules_rust//rust/platform:s390x-unknown-linux-gnu"],
    "thumbv7em-none-eabi": ["@rules_rust//rust/platform:thumbv7em-none-eabi"],
    "thumbv8m.main-none-eabi": ["@rules_rust//rust/platform:thumbv8m.main-none-eabi"],
    "wasm32-unknown-emscripten": ["@rules_rust//rust/platform:wasm32-unknown-emscripten"],
    "wasm32-unknown-unknown": ["@rules_rust//rust/platform:wasm32-unknown-unknown"],
    "wasm32-wasip1": ["@rules_rust//rust/platform:wasm32-wasip1"],
    "wasm32-wasip1-threads": ["@rules_rust//rust/platform:wasm32-wasip1-threads"],
    "wasm32-wasip2": ["@rules_rust//rust/platform:wasm32-wasip2"],
    "x86_64-apple-darwin": ["@rules_rust//rust/platform:x86_64-apple-darwin"],
    "x86_64-apple-ios": ["@rules_rust//rust/platform:x86_64-apple-ios"],
    "x86_64-linux-android": ["@rules_rust//rust/platform:x86_64-linux-android"],
    "x86_64-pc-windows-msvc": ["@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "x86_64-unknown-freebsd": ["@rules_rust//rust/platform:x86_64-unknown-freebsd"],
    "x86_64-unknown-fuchsia": ["@rules_rust//rust/platform:x86_64-unknown-fuchsia"],
    "x86_64-unknown-linux-gnu": ["@rules_rust//rust/platform:x86_64-unknown-linux-gnu"],
    "x86_64-unknown-nixos-gnu": ["@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "x86_64-unknown-none": ["@rules_rust//rust/platform:x86_64-unknown-none"],
    "x86_64-unknown-uefi": ["@rules_rust//rust/platform:x86_64-unknown-uefi"],
}

###############################################################################

def crate_repositories():
    """A macro for defining repositories for all generated crates.

    Returns:
      A list of repos visible to the module through the module extension.
    """
    maybe(
        http_archive,
        name = "vendor__anstyle-1.0.13",
        sha256 = "5192cca8006f1fd4f7237516f40fa183bb07f8fbdfedaa0036de5ea9b0b45e78",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/anstyle/1.0.13/download"],
        strip_prefix = "anstyle-1.0.13",
        build_file = Label("//third-party/bazel:BUILD.anstyle-1.0.13.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor__cc-1.2.46",
        sha256 = "b97463e1064cb1b1c1384ad0a0b9c8abd0988e2a91f52606c80ef14aadb63e36",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/cc/1.2.46/download"],
        strip_prefix = "cc-1.2.46",
        build_file = Label("//third-party/bazel:BUILD.cc-1.2.46.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor__clap-4.5.53",
        sha256 = "c9e340e012a1bf4935f5282ed1436d1489548e8f72308207ea5df0e23d2d03f8",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/clap/4.5.53/download"],
        strip_prefix = "clap-4.5.53",
        build_file = Label("//third-party/bazel:BUILD.clap-4.5.53.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor__clap_builder-4.5.53",
        sha256 = "d76b5d13eaa18c901fd2f7fca939fefe3a0727a953561fefdf3b2922b8569d00",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/clap_builder/4.5.53/download"],
        strip_prefix = "clap_builder-4.5.53",
        build_file = Label("//third-party/bazel:BUILD.clap_builder-4.5.53.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor__clap_lex-0.7.6",
        sha256 = "a1d728cc89cf3aee9ff92b05e62b19ee65a02b5702cff7d5a377e32c6ae29d8d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/clap_lex/0.7.6/download"],
        strip_prefix = "clap_lex-0.7.6",
        build_file = Label("//third-party/bazel:BUILD.clap_lex-0.7.6.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor__codespan-reporting-0.13.1",
        sha256 = "af491d569909a7e4dee0ad7db7f5341fef5c614d5b8ec8cf765732aba3cff681",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/codespan-reporting/0.13.1/download"],
        strip_prefix = "codespan-reporting-0.13.1",
        build_file = Label("//third-party/bazel:BUILD.codespan-reporting-0.13.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor__equivalent-1.0.2",
        sha256 = "877a4ace8713b0bcf2a4e7eec82529c029f1d0619886d18145fea96c3ffe5c0f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/equivalent/1.0.2/download"],
        strip_prefix = "equivalent-1.0.2",
        build_file = Label("//third-party/bazel:BUILD.equivalent-1.0.2.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor__find-msvc-tools-0.1.5",
        sha256 = "3a3076410a55c90011c298b04d0cfa770b00fa04e1e3c97d3f6c9de105a03844",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/find-msvc-tools/0.1.5/download"],
        strip_prefix = "find-msvc-tools-0.1.5",
        build_file = Label("//third-party/bazel:BUILD.find-msvc-tools-0.1.5.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor__foldhash-0.2.0",
        sha256 = "77ce24cb58228fbb8aa041425bb1050850ac19177686ea6e0f41a70416f56fdb",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/foldhash/0.2.0/download"],
        strip_prefix = "foldhash-0.2.0",
        build_file = Label("//third-party/bazel:BUILD.foldhash-0.2.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor__hashbrown-0.16.1",
        sha256 = "841d1cc9bed7f9236f321df977030373f4a4163ae1a7dbfe1a51a2c1a51d9100",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/hashbrown/0.16.1/download"],
        strip_prefix = "hashbrown-0.16.1",
        build_file = Label("//third-party/bazel:BUILD.hashbrown-0.16.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor__indexmap-2.12.1",
        sha256 = "0ad4bb2b565bca0645f4d68c5c9af97fba094e9791da685bf83cb5f3ce74acf2",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/indexmap/2.12.1/download"],
        strip_prefix = "indexmap-2.12.1",
        build_file = Label("//third-party/bazel:BUILD.indexmap-2.12.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor__proc-macro2-1.0.103",
        sha256 = "5ee95bc4ef87b8d5ba32e8b7714ccc834865276eab0aed5c9958d00ec45f49e8",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/proc-macro2/1.0.103/download"],
        strip_prefix = "proc-macro2-1.0.103",
        build_file = Label("//third-party/bazel:BUILD.proc-macro2-1.0.103.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor__quote-1.0.42",
        sha256 = "a338cc41d27e6cc6dce6cefc13a0729dfbb81c262b1f519331575dd80ef3067f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/quote/1.0.42/download"],
        strip_prefix = "quote-1.0.42",
        build_file = Label("//third-party/bazel:BUILD.quote-1.0.42.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor__rustversion-1.0.22",
        sha256 = "b39cdef0fa800fc44525c84ccb54a029961a8215f9619753635a9c0d2538d46d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/rustversion/1.0.22/download"],
        strip_prefix = "rustversion-1.0.22",
        build_file = Label("//third-party/bazel:BUILD.rustversion-1.0.22.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor__scratch-1.0.9",
        sha256 = "d68f2ec51b097e4c1a75b681a8bec621909b5e91f15bb7b840c4f2f7b01148b2",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/scratch/1.0.9/download"],
        strip_prefix = "scratch-1.0.9",
        build_file = Label("//third-party/bazel:BUILD.scratch-1.0.9.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor__serde-1.0.228",
        sha256 = "9a8e94ea7f378bd32cbbd37198a4a91436180c5bb472411e48b5ec2e2124ae9e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde/1.0.228/download"],
        strip_prefix = "serde-1.0.228",
        build_file = Label("//third-party/bazel:BUILD.serde-1.0.228.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor__serde_core-1.0.228",
        sha256 = "41d385c7d4ca58e59fc732af25c3983b67ac852c1a25000afe1175de458b67ad",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde_core/1.0.228/download"],
        strip_prefix = "serde_core-1.0.228",
        build_file = Label("//third-party/bazel:BUILD.serde_core-1.0.228.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor__serde_derive-1.0.228",
        sha256 = "d540f220d3187173da220f885ab66608367b6574e925011a9353e4badda91d79",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde_derive/1.0.228/download"],
        strip_prefix = "serde_derive-1.0.228",
        build_file = Label("//third-party/bazel:BUILD.serde_derive-1.0.228.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor__shlex-1.3.0",
        sha256 = "0fda2ff0d084019ba4d7c6f371c95d8fd75ce3524c3cb8fb653a3023f6323e64",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/shlex/1.3.0/download"],
        strip_prefix = "shlex-1.3.0",
        build_file = Label("//third-party/bazel:BUILD.shlex-1.3.0.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor__syn-2.0.110",
        sha256 = "a99801b5bd34ede4cf3fc688c5919368fea4e4814a4664359503e6015b280aea",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/syn/2.0.110/download"],
        strip_prefix = "syn-2.0.110",
        build_file = Label("//third-party/bazel:BUILD.syn-2.0.110.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor__termcolor-1.4.1",
        sha256 = "06794f8f6c5c898b3275aebefa6b8a1cb24cd2c6c79397ab15774837a0bc5755",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/termcolor/1.4.1/download"],
        strip_prefix = "termcolor-1.4.1",
        build_file = Label("//third-party/bazel:BUILD.termcolor-1.4.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor__unicode-ident-1.0.22",
        sha256 = "9312f7c4f6ff9069b165498234ce8be658059c6728633667c526e27dc2cf1df5",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/unicode-ident/1.0.22/download"],
        strip_prefix = "unicode-ident-1.0.22",
        build_file = Label("//third-party/bazel:BUILD.unicode-ident-1.0.22.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor__unicode-width-0.2.2",
        sha256 = "b4ac048d71ede7ee76d585517add45da530660ef4390e49b098733c6e897f254",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/unicode-width/0.2.2/download"],
        strip_prefix = "unicode-width-0.2.2",
        build_file = Label("//third-party/bazel:BUILD.unicode-width-0.2.2.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor__winapi-util-0.1.11",
        sha256 = "c2a7b1c03c876122aa43f3020e6c3c3ee5c05081c9a00739faf7503aeba10d22",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/winapi-util/0.1.11/download"],
        strip_prefix = "winapi-util-0.1.11",
        build_file = Label("//third-party/bazel:BUILD.winapi-util-0.1.11.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor__windows-link-0.2.1",
        sha256 = "f0805222e57f7521d6a62e36fa9163bc891acd422f971defe97d64e70d0a4fe5",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-link/0.2.1/download"],
        strip_prefix = "windows-link-0.2.1",
        build_file = Label("//third-party/bazel:BUILD.windows-link-0.2.1.bazel"),
    )

    maybe(
        http_archive,
        name = "vendor__windows-sys-0.61.2",
        sha256 = "ae137229bcbd6cdf0f7b80a31df61766145077ddf49416a728b02cb3921ff3fc",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-sys/0.61.2/download"],
        strip_prefix = "windows-sys-0.61.2",
        build_file = Label("//third-party/bazel:BUILD.windows-sys-0.61.2.bazel"),
    )

    return [
        struct(repo = "vendor__cc-1.2.46", is_dev_dep = False),
        struct(repo = "vendor__clap-4.5.53", is_dev_dep = False),
        struct(repo = "vendor__codespan-reporting-0.13.1", is_dev_dep = False),
        struct(repo = "vendor__foldhash-0.2.0", is_dev_dep = False),
        struct(repo = "vendor__indexmap-2.12.1", is_dev_dep = False),
        struct(repo = "vendor__proc-macro2-1.0.103", is_dev_dep = False),
        struct(repo = "vendor__quote-1.0.42", is_dev_dep = False),
        struct(repo = "vendor__rustversion-1.0.22", is_dev_dep = False),
        struct(repo = "vendor__scratch-1.0.9", is_dev_dep = False),
        struct(repo = "vendor__serde-1.0.228", is_dev_dep = False),
        struct(repo = "vendor__syn-2.0.110", is_dev_dep = False),
    ]
