/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.tjEnterprises.phase10Counter.ui.theme

import androidx.compose.ui.graphics.Color

/*
*   https://m3.material.io/theme-builder#/custom
*   Primary: #3378c8
*   Secondary: #009bd1
*   Tertiary: #e6f2ff
*   Neutral: #919094
*/

val primaryLight = Color(0xFF3C6090)
val onPrimaryLight = Color(0xFFFFFFFF)
val primaryContainerLight = Color(0xFFD4E3FF)
val onPrimaryContainerLight = Color(0xFF001C3A)
val secondaryLight = Color(0xFF1D6586)
val onSecondaryLight = Color(0xFFFFFFFF)
val secondaryContainerLight = Color(0xFFC4E7FF)
val onSecondaryContainerLight = Color(0xFF001E2C)
val tertiaryLight = Color(0xFF4A5C92)
val onTertiaryLight = Color(0xFFFFFFFF)
val tertiaryContainerLight = Color(0xFFDBE1FF)
val onTertiaryContainerLight = Color(0xFF001849)
val errorLight = Color(0xFFBA1A1A)
val onErrorLight = Color(0xFFFFFFFF)
val errorContainerLight = Color(0xFFFFDAD6)
val onErrorContainerLight = Color(0xFF410002)
val backgroundLight = Color(0xFFF9F9FF)
val onBackgroundLight = Color(0xFF191C20)
val surfaceLight = Color(0xFFFAF8FF)
val onSurfaceLight = Color(0xFF1A1B21)
val surfaceVariantLight = Color(0xFFE0E2EC)
val onSurfaceVariantLight = Color(0xFF43474E)
val outlineLight = Color(0xFF74777F)
val outlineVariantLight = Color(0xFFC3C6CF)
val scrimLight = Color(0xFF000000)
val inverseSurfaceLight = Color(0xFF2F3036)
val inverseOnSurfaceLight = Color(0xFFF1F0F7)
val inversePrimaryLight = Color(0xFFA5C8FF)
val surfaceDimLight = Color(0xFFDAD9E0)
val surfaceBrightLight = Color(0xFFFAF8FF)
val surfaceContainerLowestLight = Color(0xFFFFFFFF)
val surfaceContainerLowLight = Color(0xFFF4F3FA)
val surfaceContainerLight = Color(0xFFEEEDF4)
val surfaceContainerHighLight = Color(0xFFE8E7EF)
val surfaceContainerHighestLight = Color(0xFFE3E2E9)

val primaryDark = Color(0xFFA5C8FF)
val onPrimaryDark = Color(0xFF00315E)
val primaryContainerDark = Color(0xFF224876)
val onPrimaryContainerDark = Color(0xFFD4E3FF)
val secondaryDark = Color(0xFF90CEF4)
val onSecondaryDark = Color(0xFF00344A)
val secondaryContainerDark = Color(0xFF004C69)
val onSecondaryContainerDark = Color(0xFFC4E7FF)
val tertiaryDark = Color(0xFFB3C5FF)
val onTertiaryDark = Color(0xFF192E60)
val tertiaryContainerDark = Color(0xFF314578)
val onTertiaryContainerDark = Color(0xFFDBE1FF)
val errorDark = Color(0xFFFFB4AB)
val onErrorDark = Color(0xFF690005)
val errorContainerDark = Color(0xFF93000A)
val onErrorContainerDark = Color(0xFFFFDAD6)
val backgroundDark = Color(0xFF111318)
val onBackgroundDark = Color(0xFFE1E2E9)
val surfaceDark = Color(0xFF121318)
val onSurfaceDark = Color(0xFFE3E2E9)
val surfaceVariantDark = Color(0xFF43474E)
val onSurfaceVariantDark = Color(0xFFC3C6CF)
val outlineDark = Color(0xFF8D9199)
val outlineVariantDark = Color(0xFF43474E)
val scrimDark = Color(0xFF000000)
val inverseSurfaceDark = Color(0xFFE3E2E9)
val inverseOnSurfaceDark = Color(0xFF2F3036)
val inversePrimaryDark = Color(0xFF3C6090)
val surfaceDimDark = Color(0xFF121318)
val surfaceBrightDark = Color(0xFF38393F)
val surfaceContainerLowestDark = Color(0xFF0D0E13)
val surfaceContainerLowDark = Color(0xFF1A1B21)
val surfaceContainerDark = Color(0xFF1E1F25)
val surfaceContainerHighDark = Color(0xFF292A2F)
val surfaceContainerHighestDark = Color(0xFF33343A)
