import dayjs from "dayjs";
import { AbstractParserWithWordBoundaryChecking } from "../../../common/parsers/AbstractParserWithWordBoundary.js";
import { assignSimilarDate } from "../../../utils/dayjs.js";
import * as references from "../../../common/casualReferences.js";
const PATTERN = /(ora|oggi|stasera|questa sera|domani|dmn|ieri\s*sera)(?=\W|$)/i;
export default class ENCasualDateParser extends AbstractParserWithWordBoundaryChecking {
    innerPattern(context) {
        return PATTERN;
    }
    innerExtract(context, match) {
        let targetDate = dayjs(context.refDate);
        const lowerText = match[0].toLowerCase();
        const component = context.createParsingComponents();
        switch (lowerText) {
            case "ora":
                return references.now(context.reference);
            case "oggi":
                return references.today(context.reference);
            case "ieri":
                return references.yesterday(context.reference);
            case "domani":
            case "dmn":
                return references.tomorrow(context.reference);
            case "stasera":
            case "questa sera":
                return references.tonight(context.reference);
            default:
                if (lowerText.match(/ieri\s*sera/)) {
                    if (targetDate.hour() > 6) {
                        targetDate = targetDate.add(-1, "day");
                    }
                    assignSimilarDate(component, targetDate);
                    component.imply("hour", 0);
                }
                break;
        }
        return component;
    }
}
//# sourceMappingURL=ITCasualDateParser.js.map