"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.assignSimilarDate = assignSimilarDate;
exports.assignSimilarTime = assignSimilarTime;
exports.implySimilarDate = implySimilarDate;
exports.implySimilarTime = implySimilarTime;
const types_1 = require("../types");
function assignSimilarDate(component, target) {
    component.assign("day", target.getDate());
    component.assign("month", target.getMonth() + 1);
    component.assign("year", target.getFullYear());
}
function assignSimilarTime(component, target) {
    component.assign("hour", target.getHours());
    component.assign("minute", target.getMinutes());
    component.assign("second", target.getSeconds());
    component.assign("millisecond", target.getMilliseconds());
    component.assign("meridiem", target.getHours() < 12 ? types_1.Meridiem.AM : types_1.Meridiem.PM);
}
function implySimilarDate(component, target) {
    component.imply("day", target.getDate());
    component.imply("month", target.getMonth() + 1);
    component.imply("year", target.getFullYear());
}
function implySimilarTime(component, target) {
    component.imply("hour", target.getHours());
    component.imply("minute", target.getMinutes());
    component.imply("second", target.getSeconds());
    component.imply("millisecond", target.getMilliseconds());
    component.imply("meridiem", target.getHours() < 12 ? types_1.Meridiem.AM : types_1.Meridiem.PM);
}
//# sourceMappingURL=dates.js.map