export type PackageJson = {
    name: string;
    version: string;
    dependencies?: Record<string, string>;
    devDependencies?: Record<string, string>;
    peerDependencies?: Record<string, string>;
    optionalDependencies?: Record<string, string>;
    workspaces?: string[] | {
        packages: string[];
    };
};
export type ResolveModuleOptions<T> = {
    dependency: T;
    virtualPath?: string;
    isOptionalDependency?: boolean;
};
export interface NodeModuleInfo {
    name: string;
    version: string;
    dir: string;
    dependencies?: Array<NodeModuleInfo>;
}
export type ParsedDependencyTree = {
    readonly name: string;
    readonly version: string;
    readonly path: string;
    readonly workspaces?: string[] | {
        packages: string[];
    };
};
export interface PnpmDependency extends Dependency<PnpmDependency, PnpmDependency> {
    readonly from: string;
    readonly resolved: string;
}
export interface NpmDependency extends Dependency<NpmDependency, string> {
    readonly resolved?: string;
    readonly _dependencies?: {
        [packageName: string]: string;
    };
}
export interface YarnBerryDependency extends Dependency<YarnBerryDependency, string> {
}
export interface YarnDependency extends Dependency<YarnDependency, YarnDependency> {
}
export type Dependency<T, V> = Dependencies<T, V> & ParsedDependencyTree;
export type Dependencies<T, V> = {
    readonly dependencies?: {
        [packageName: string]: T;
    };
    readonly optionalDependencies?: {
        [packageName: string]: V;
    };
};
export interface DependencyGraph {
    [packageNameAndVersion: string]: PackageDependencies;
}
interface PackageDependencies {
    readonly dependencies: string[];
}
export {};
