import { TmpDir } from "builder-util";
import { CancellationToken } from "builder-util-runtime";
import * as fs from "fs-extra";
import { Lazy } from "lazy-val";
import { PM } from "./packageManager";
import type { Dependency, DependencyGraph, NodeModuleInfo, PackageJson } from "./types";
export declare abstract class NodeModulesCollector<ProdDepType extends Dependency<ProdDepType, OptionalDepType>, OptionalDepType> {
    protected readonly rootDir: string;
    private readonly tempDirManager;
    private readonly nodeModules;
    protected readonly allDependencies: Map<string, ProdDepType>;
    protected readonly productionGraph: DependencyGraph;
    private readonly cache;
    protected readonly isHoisted: Lazy<boolean>;
    protected appPkgJson: Lazy<PackageJson>;
    constructor(rootDir: string, tempDirManager: TmpDir);
    getNodeModules({ cancellationToken, packageName }: {
        cancellationToken: CancellationToken;
        packageName: string;
    }): Promise<NodeModuleInfo[]>;
    abstract readonly installOptions: {
        manager: PM;
        lockfile: string;
    };
    protected abstract getArgs(): string[];
    protected abstract parseDependenciesTree(jsonBlob: string): Promise<ProdDepType>;
    protected abstract extractProductionDependencyGraph(tree: Dependency<ProdDepType, OptionalDepType>, dependencyId: string): Promise<void>;
    protected abstract collectAllDependencies(tree: Dependency<ProdDepType, OptionalDepType>, appPackageName: string): Promise<void>;
    protected getDependenciesTree(pm: PM): Promise<ProdDepType>;
    protected existsMemoized(filePath: string): Promise<boolean>;
    protected readJsonMemoized(filePath: string): Promise<PackageJson>;
    protected lstatMemoized(filePath: string): Promise<fs.Stats>;
    protected realpathMemoized(filePath: string): Promise<string>;
    protected requireMemoized(pkgPath: string): PackageJson;
    protected existsSyncMemoized(filePath: string): boolean;
    protected resolvePath(filePath: string): Promise<string>;
    /**
     * Resolve a package directory purely from the filesystem.
     * Does NOT attempt to load the module or resolve an "exports" entrypoint.
     * Good for Yarn 4 because a package may not be resolvable as a module,
     * but still exists on disk.
     */
    protected resolvePackage(packageName: string, fromDir: string): Promise<{
        entry: string;
        packageDir: string;
    } | null>;
    protected cacheKey(pkg: ProdDepType): string;
    protected packageVersionString(pkg: ProdDepType): string;
    /**
     * Parse a dependency identifier like "@scope/pkg@1.2.3" or "pkg@1.2.3"
     */
    protected parseNameVersion(identifier: string): {
        name: string;
        version: string;
    };
    protected getTreeFromWorkspaces(tree: ProdDepType, packageName: string): Promise<ProdDepType>;
    private transformToHoisterTree;
    private _getNodeModules;
    asyncExec(command: string, args: string[], cwd?: string): Promise<{
        stdout: string | undefined;
        stderr: string | undefined;
    }>;
    streamCollectorCommandToFile(command: string, args: string[], cwd: string, tempOutputFile: string): Promise<void>;
}
