import { NamingConvention } from "../NamingConvention.mjs";

import { OpenApiStationValidator } from "./OpenApiStationValidator.mjs";

var OpenApiObjectValidator;

(function(OpenApiObjectValidator) {
    OpenApiObjectValidator.validate = ctx => {
        if (typeof ctx.value !== "object" || ctx.value === null) return ctx.report(ctx);
        return [ ...Object.entries(ctx.schema.properties ?? {}).map((([key, value]) => OpenApiStationValidator.validate({
            ...ctx,
            schema: value,
            value: ctx.value[key],
            path: ctx.path + (NamingConvention.variable(key) ? `.${key}` : `[${JSON.stringify(key)}]`),
            required: ctx.schema.required?.includes(key) ?? false
        }))), ...typeof ctx.schema.additionalProperties === "object" && ctx.schema.additionalProperties !== null ? Object.entries(ctx.value).filter((([key]) => Object.keys(ctx.schema.properties ?? {}).includes(key) === false)).map((([key, value]) => OpenApiStationValidator.validate({
            ...ctx,
            schema: ctx.schema.additionalProperties,
            value,
            path: ctx.path + (NamingConvention.variable(key) ? `.${key}` : `[${JSON.stringify(key)}]`),
            required: true
        }))) : [] ].every((v => v));
    };
})(OpenApiObjectValidator || (OpenApiObjectValidator = {}));

export { OpenApiObjectValidator };
//# sourceMappingURL=OpenApiObjectValidator.mjs.map
