import { Escaper } from "../Escaper.mjs";

import { OpenApiTypeChecker } from "../OpenApiTypeChecker.mjs";

var JsonDescriptionUtil;

(function(JsonDescriptionUtil) {
    JsonDescriptionUtil.cascade = props => {
        const accessors = props.schema.$ref.split(props.prefix)[1].split(".");
        const pReferences = accessors.slice(0, props.escape ? accessors.length : accessors.length - 1).map(((_, i, array) => array.slice(0, i + 1).join("."))).map((key => ({
            key,
            description: props.components.schemas?.[key]?.description
        }))).reverse().filter(((schema, i) => i === 0 || !!schema?.description));
        if (!props.schema.description?.length && pReferences.length === 0) return undefined;
        return [ ...!!props.schema.description?.length ? [ props.schema.description ] : [], ...pReferences.map(((pRef, i) => pRef.description === undefined ? `Current Type: {@link ${pRef.key}}` : `Description of the ${i === 0 && props.escape ? "current" : "parent"} {@link ${pRef.key}} type:\n\n` + pRef.description.split("\n").map((str => `> ${str}`)).join("\n"))) ].join("\n\n------------------------------\n\n");
    };
    JsonDescriptionUtil.take = o => [ ...!!o.description?.length ? [ o.description ] : [], ...Object.entries(o.properties ?? {}).filter((([_key, value]) => OpenApiTypeChecker.isReference(value) && !!value.description?.length)).map((([key, value]) => `### Description of {@link ${Escaper.variable(key) ? key : JSON.stringify(key)}} property:\n\n` + (value.description ?? "").split("\n").map((str => `> ${str}`)).join("\n"))) ].join("\n\n");
})(JsonDescriptionUtil || (JsonDescriptionUtil = {}));

export { JsonDescriptionUtil };
//# sourceMappingURL=JsonDescriptionUtil.mjs.map
