import { OpenApiStationValidator } from "./internal/OpenApiStationValidator.mjs";

var OpenApiValidator;

(function(OpenApiValidator) {
    OpenApiValidator.create = prop => value => OpenApiValidator.validate({
        ...prop,
        value
    });
    OpenApiValidator.validate = props => {
        const errors = [];
        OpenApiStationValidator.validate({
            ...props,
            path: "$input",
            exceptionable: true,
            report: createReporter(errors)
        });
        return errors.length === 0 ? {
            success: true,
            data: props.value
        } : {
            success: false,
            data: props.value,
            errors
        };
    };
    const createReporter = array => {
        const reportable = path => {
            if (array.length === 0) return true;
            const last = array[array.length - 1].path;
            return path.length > last.length || last.substring(0, path.length) !== path;
        };
        return error => {
            if (error.exceptionable && reportable(error.path)) array.push({
                path: error.path,
                expected: error.expected,
                value: error.value
            });
            return false;
        };
    };
})(OpenApiValidator || (OpenApiValidator = {}));

export { OpenApiValidator };
//# sourceMappingURL=OpenApiValidator.mjs.map
