import { OpenApiTypeCheckerBase } from "./internal/OpenApiTypeCheckerBase.mjs";

var LlmTypeCheckerV3_1;

(function(LlmTypeCheckerV3_1) {
    LlmTypeCheckerV3_1.isNull = schema => OpenApiTypeCheckerBase.isNull(schema);
    LlmTypeCheckerV3_1.isUnknown = schema => OpenApiTypeCheckerBase.isUnknown(schema);
    LlmTypeCheckerV3_1.isConstant = schema => OpenApiTypeCheckerBase.isConstant(schema);
    LlmTypeCheckerV3_1.isBoolean = schema => OpenApiTypeCheckerBase.isBoolean(schema);
    LlmTypeCheckerV3_1.isInteger = schema => OpenApiTypeCheckerBase.isInteger(schema);
    LlmTypeCheckerV3_1.isNumber = schema => OpenApiTypeCheckerBase.isNumber(schema);
    LlmTypeCheckerV3_1.isString = schema => OpenApiTypeCheckerBase.isString(schema);
    LlmTypeCheckerV3_1.isArray = schema => OpenApiTypeCheckerBase.isArray(schema);
    LlmTypeCheckerV3_1.isObject = schema => OpenApiTypeCheckerBase.isObject(schema);
    LlmTypeCheckerV3_1.isReference = schema => OpenApiTypeCheckerBase.isReference(schema);
    LlmTypeCheckerV3_1.isOneOf = schema => OpenApiTypeCheckerBase.isOneOf(schema);
    LlmTypeCheckerV3_1.isRecursiveReference = props => OpenApiTypeCheckerBase.isRecursiveReference({
        prefix: "#/$defs/",
        components: {
            schemas: props.$defs
        },
        schema: props.schema
    });
    LlmTypeCheckerV3_1.covers = props => OpenApiTypeCheckerBase.covers({
        prefix: "#/$defs/",
        components: {
            schemas: props.$defs
        },
        x: props.x,
        y: props.y
    });
    LlmTypeCheckerV3_1.visit = props => OpenApiTypeCheckerBase.visit({
        prefix: "#/$defs/",
        components: {
            schemas: props.$defs
        },
        closure: props.closure,
        schema: props.schema
    });
})(LlmTypeCheckerV3_1 || (LlmTypeCheckerV3_1 = {}));

export { LlmTypeCheckerV3_1 };
//# sourceMappingURL=LlmTypeCheckerV3_1.mjs.map
