import { ILlmSchemaV3_1 } from "../structures/ILlmSchemaV3_1";
export declare namespace LlmTypeCheckerV3_1 {
    /**
     * Test whether the schema is a nul type.
     *
     * @param schema Target schema
     * @returns Whether null type or not
     */
    const isNull: (schema: ILlmSchemaV3_1) => schema is ILlmSchemaV3_1.INull;
    /**
     * Test whether the schema is an unknown type.
     *
     * @param schema Target schema
     * @returns Whether unknown type or not
     */
    const isUnknown: (schema: ILlmSchemaV3_1) => schema is ILlmSchemaV3_1.IUnknown;
    /**
     * Test whether the schema is a constant type.
     *
     * @param schema Target schema
     * @returns Whether constant type or not
     */
    const isConstant: (schema: ILlmSchemaV3_1) => schema is ILlmSchemaV3_1.IConstant;
    /**
     * Test whether the schema is a boolean type.
     *
     * @param schema Target schema
     * @returns Whether boolean type or not
     */
    const isBoolean: (schema: ILlmSchemaV3_1) => schema is ILlmSchemaV3_1.IBoolean;
    /**
     * Test whether the schema is an integer type.
     *
     * @param schema Target schema
     * @returns Whether integer type or not
     */
    const isInteger: (schema: ILlmSchemaV3_1) => schema is ILlmSchemaV3_1.IInteger;
    /**
     * Test whether the schema is a number type.
     *
     * @param schema Target schema
     * @returns Whether number type or not
     */
    const isNumber: (schema: ILlmSchemaV3_1) => schema is ILlmSchemaV3_1.INumber;
    /**
     * Test whether the schema is a string type.
     *
     * @param schema Target schema
     * @returns Whether string type or not
     */
    const isString: (schema: ILlmSchemaV3_1) => schema is ILlmSchemaV3_1.IString;
    /**
     * Test whether the schema is an array type.
     *
     * @param schema Target schema
     * @returns Whether array type or not
     */
    const isArray: (schema: ILlmSchemaV3_1) => schema is ILlmSchemaV3_1.IArray;
    /**
     * Test whether the schema is an object type.
     *
     * @param schema Target schema
     * @returns Whether object type or not
     */
    const isObject: (schema: ILlmSchemaV3_1) => schema is ILlmSchemaV3_1.IObject;
    /**
     * Test whether the schema is a reference type.
     *
     * @param schema Target schema
     * @returns Whether reference type or not
     */
    const isReference: (schema: ILlmSchemaV3_1) => schema is ILlmSchemaV3_1.IReference;
    /**
     * Test whether the schema is an union type.
     *
     * @param schema Target schema
     * @returns Whether union type or not
     */
    const isOneOf: (schema: ILlmSchemaV3_1) => schema is ILlmSchemaV3_1.IOneOf;
    /**
     * Test whether the schema is recursive reference type.
     *
     * Test whether the target schema is a reference type, and test one thing more
     * that the reference is self-recursive or not.
     *
     * @param props Properties for recursive reference test
     * @returns Whether the schema is recursive reference type or not
     */
    const isRecursiveReference: (props: {
        $defs?: Record<string, ILlmSchemaV3_1>;
        schema: ILlmSchemaV3_1;
    }) => boolean;
    /**
     * Test whether the `x` schema covers the `y` schema.
     *
     * @param props Properties for testing
     * @returns Whether the `x` schema covers the `y` schema
     */
    const covers: (props: {
        $defs?: Record<string, ILlmSchemaV3_1>;
        x: ILlmSchemaV3_1;
        y: ILlmSchemaV3_1;
    }) => boolean;
    /**
     * Visit every nested schemas.
     *
     * Visit every nested schemas of the target, and apply the `props.closure` function.
     *
     * Here is the list of occurring nested visitings:
     *
     * - {@link ILlmSchemaV3_1.IOneOf.oneOf}
     * - {@link ILlmSchemaV3_1.IReference}
     * - {@link ILlmSchemaV3_1.IObject.properties}
     * - {@link ILlmSchemaV3_1.IObject.additionalProperties}
     * - {@link ILlmSchemaV3_1.IArray.items}
     *
     * @param props Properties for visiting
     */
    const visit: (props: {
        closure: (schema: ILlmSchemaV3_1, accessor: string) => void;
        $defs?: Record<string, ILlmSchemaV3_1>;
        schema: ILlmSchemaV3_1;
    }) => void;
}
