var LlmDataMerger;

(function(LlmDataMerger) {
    LlmDataMerger.parameters = props => {
        const separated = props.function.separated;
        if (separated === undefined) throw new Error("Error on OpenAiDataComposer.parameters(): the function parameters are not separated.");
        return LlmDataMerger.value(props.llm, props.human);
    };
    LlmDataMerger.value = (x, y) => typeof x === "object" && typeof y === "object" && x !== null && y !== null ? combineObject(x, y) : Array.isArray(x) && Array.isArray(y) ? new Array(Math.max(x.length, y.length)).fill(0).map(((_, i) => LlmDataMerger.value(x[i], y[i]))) : y ?? x;
    const combineObject = (x, y) => {
        const output = {
            ...x
        };
        for (const [k, v] of Object.entries(y)) output[k] = LlmDataMerger.value(x[k], v);
        return output;
    };
})(LlmDataMerger || (LlmDataMerger = {}));

export { LlmDataMerger };
//# sourceMappingURL=LlmDataMerger.mjs.map
