var GeminiTypeChecker;

(function(GeminiTypeChecker) {
    GeminiTypeChecker.visit = props => {
        const accessor = props.accessor ?? "$input.schema";
        props.closure(props.schema, accessor);
        if (GeminiTypeChecker.isObject(props.schema)) Object.entries(props.schema.properties ?? {}).forEach((([key, value]) => GeminiTypeChecker.visit({
            closure: props.closure,
            schema: value,
            accessor: `${accessor}.properties[${JSON.stringify(key)}]`
        }))); else if (GeminiTypeChecker.isArray(props.schema)) GeminiTypeChecker.visit({
            closure: props.closure,
            schema: props.schema.items,
            accessor: `${accessor}.items`
        });
    };
    GeminiTypeChecker.covers = (x, y) => {
        if (x === y) return true; else if (GeminiTypeChecker.isUnknown(x)) return true; else if (GeminiTypeChecker.isUnknown(y)) return false; else if (GeminiTypeChecker.isNullOnly(x)) return GeminiTypeChecker.isNullOnly(y); else if (GeminiTypeChecker.isNullOnly(y)) return x.nullable === true; else if (x.nullable === true && !!y.nullable === false) return false; else if (GeminiTypeChecker.isBoolean(x)) return GeminiTypeChecker.isBoolean(y) && coverBoolean(x, y); else if (GeminiTypeChecker.isInteger(x)) return GeminiTypeChecker.isInteger(y) && coverInteger(x, y); else if (GeminiTypeChecker.isNumber(x)) return (GeminiTypeChecker.isNumber(y) || GeminiTypeChecker.isInteger(y)) && coverNumber(x, y); else if (GeminiTypeChecker.isString(x)) return GeminiTypeChecker.isString(y) && covertString(x, y); else if (GeminiTypeChecker.isArray(x)) return GeminiTypeChecker.isArray(y) && coverArray(x, y); else if (GeminiTypeChecker.isObject(x)) return GeminiTypeChecker.isObject(y) && coverObject(x, y);
        return false;
    };
    const coverBoolean = (x, y) => x.enum === undefined || y.enum !== undefined && x.enum.every((v => y.enum.includes(v)));
    const coverInteger = (x, y) => {
        if (x.enum !== undefined) return y.enum !== undefined && x.enum.every((v => y.enum.includes(v)));
        return x.type === y.type;
    };
    const coverNumber = (x, y) => {
        if (x.enum !== undefined) return y.enum !== undefined && x.enum.every((v => y.enum.includes(v)));
        return x.type === y.type;
    };
    const covertString = (x, y) => {
        if (x.enum !== undefined) return y.enum !== undefined && x.enum.every((v => y.enum.includes(v)));
        return x.type === y.type;
    };
    const coverArray = (x, y) => GeminiTypeChecker.covers(x.items, y.items);
    const coverObject = (x, y) => Object.entries(y.properties ?? {}).every((([key, b]) => {
        const a = x.properties?.[key];
        if (a === undefined) return false; else if ((x.required?.includes(key) ?? false) === true && (y.required?.includes(key) ?? false) === false) return false;
        return GeminiTypeChecker.covers(a, b);
    }));
    GeminiTypeChecker.isBoolean = schema => schema.type === "boolean";
    GeminiTypeChecker.isInteger = schema => schema.type === "integer";
    GeminiTypeChecker.isNumber = schema => schema.type === "number";
    GeminiTypeChecker.isString = schema => schema.type === "string";
    GeminiTypeChecker.isArray = schema => schema.type === "array";
    GeminiTypeChecker.isObject = schema => schema.type === "object";
    GeminiTypeChecker.isNullOnly = schema => schema.type === "null";
    GeminiTypeChecker.isNullable = schema => !GeminiTypeChecker.isUnknown(schema) && (GeminiTypeChecker.isNullOnly(schema) || schema.nullable === true);
    GeminiTypeChecker.isUnknown = schema => schema.type === undefined;
})(GeminiTypeChecker || (GeminiTypeChecker = {}));

export { GeminiTypeChecker };
//# sourceMappingURL=GeminiTypeChecker.mjs.map
