import { IChatGptSchema } from "../structures/IChatGptSchema";
export declare namespace ChatGptTypeChecker {
    /**
     * Test whether the schema is a nul type.
     *
     * @param schema Target schema
     * @returns Whether null type or not
     */
    const isNull: (schema: IChatGptSchema) => schema is IChatGptSchema.INull;
    /**
     * Test whether the schema is an unknown type.
     *
     * @param schema Target schema
     * @returns Whether unknown type or not
     */
    const isUnknown: (schema: IChatGptSchema) => schema is IChatGptSchema.IUnknown;
    /**
     * Test whether the schema is a boolean type.
     *
     * @param schema Target schema
     * @returns Whether boolean type or not
     */
    const isBoolean: (schema: IChatGptSchema) => schema is IChatGptSchema.IBoolean;
    /**
     * Test whether the schema is an integer type.
     *
     * @param schema Target schema
     * @returns Whether integer type or not
     */
    const isInteger: (schema: IChatGptSchema) => schema is IChatGptSchema.IInteger;
    /**
     * Test whether the schema is a number type.
     *
     * @param schema Target schema
     * @returns Whether number type or not
     */
    const isNumber: (schema: IChatGptSchema) => schema is IChatGptSchema.INumber;
    /**
     * Test whether the schema is a string type.
     *
     * @param schema Target schema
     * @returns Whether string type or not
     */
    const isString: (schema: IChatGptSchema) => schema is IChatGptSchema.IString;
    /**
     * Test whether the schema is an array type.
     *
     * @param schema Target schema
     * @returns Whether array type or not
     */
    const isArray: (schema: IChatGptSchema) => schema is IChatGptSchema.IArray;
    /**
     * Test whether the schema is an object type.
     *
     * @param schema Target schema
     * @returns Whether object type or not
     */
    const isObject: (schema: IChatGptSchema) => schema is IChatGptSchema.IObject;
    /**
     * Test whether the schema is a reference type.
     *
     * @param schema Target schema
     * @returns Whether reference type or not
     */
    const isReference: (schema: IChatGptSchema) => schema is IChatGptSchema.IReference;
    /**
     * Test whether the schema is an union type.
     *
     * @param schema Target schema
     * @returns Whether union type or not
     */
    const isAnyOf: (schema: IChatGptSchema) => schema is IChatGptSchema.IAnyOf;
    /**
     * Visit every nested schemas.
     *
     * Visit every nested schemas of the target, and apply the `props.closure` function.
     *
     * Here is the list of occurring nested visitings:
     *
     * - {@link IChatGptSchema.IAnyOf.anyOf}
     * - {@link IChatGptSchema.IReference}
     * - {@link IChatGptSchema.IObject.properties}
     * - {@link IChatGptSchema.IArray.items}
     *
     * @param props Properties for visiting
     */
    const visit: (props: {
        closure: (schema: IChatGptSchema, accessor: string) => void;
        $defs?: Record<string, IChatGptSchema> | undefined;
        schema: IChatGptSchema;
        accessor?: string;
        refAccessor?: string;
    }) => void;
    /**
     * Test whether the `x` schema covers the `y` schema.
     *
     * @param props Properties for testing
     * @returns Whether the `x` schema covers the `y` schema
     */
    const covers: (props: {
        $defs?: Record<string, IChatGptSchema> | undefined;
        x: IChatGptSchema;
        y: IChatGptSchema;
    }) => boolean;
}
