export type IValidation<T = unknown> = IValidation.ISuccess<T> | IValidation.IFailure;
export declare namespace IValidation {
    interface ISuccess<T = unknown> {
        success: true;
        data: T;
    }
    interface IFailure {
        success: false;
        data: unknown;
        errors: IError[];
    }
    interface IError {
        path: string;
        expected: string;
        value: any;
    }
}
