"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpError = void 0;
/**
 * HTTP Error.
 *
 * `HttpError` is a type of error class who've been thrown by the remote HTTP server.
 *
 * @author Jeongho Nam - https://github.com/samchon
 */
class HttpError extends Error {
    /**
     * Initializer Constructor.
     *
     * @param method Method of the HTTP request.
     * @param path Path of the HTTP request.
     * @param status Status code from the remote HTTP server.
     * @param message Error message from the remote HTTP server.
     */
    constructor(method, path, status, headers, message) {
        super(message);
        this.method = method;
        this.path = path;
        this.status = status;
        this.headers = headers;
        /**
         * @internal
         */
        this.body_ = NOT_YET;
        // INHERITANCE POLYFILL
        const proto = new.target.prototype;
        if (Object.setPrototypeOf)
            Object.setPrototypeOf(this, proto);
        else
            this.__proto__ = proto;
    }
    /**
     * `HttpError` to JSON.
     *
     * When you call `JSON.stringify()` function on current `HttpError` instance,
     * this `HttpError.toJSON()` method would be automatically called.
     *
     * Also, if response body from the remote HTTP server forms a JSON object,
     * this `HttpError.toJSON()` method would be useful because it returns the
     * parsed JSON object about the {@link message} property.
     *
     * @template T Expected type of the response body.
     * @returns JSON object of the `HttpError`.
     */
    toJSON() {
        if (this.body_ === NOT_YET)
            try {
                this.body_ = JSON.parse(this.message);
            }
            catch (_a) {
                this.body_ = this.message;
            }
        return {
            method: this.method,
            path: this.path,
            status: this.status,
            headers: this.headers,
            message: this.body_,
        };
    }
}
exports.HttpError = HttpError;
const NOT_YET = {};
