/**
 * HTTP Error.
 *
 * `HttpError` is a type of error class who've been thrown by the remote HTTP server.
 *
 * @author Jeongho Nam - https://github.com/samchon
 */
export declare class HttpError extends Error {
    readonly method: "GET" | "DELETE" | "POST" | "PUT" | "PATCH" | "HEAD";
    readonly path: string;
    readonly status: number;
    readonly headers: Record<string, string | string[]>;
    /**
     * Initializer Constructor.
     *
     * @param method Method of the HTTP request.
     * @param path Path of the HTTP request.
     * @param status Status code from the remote HTTP server.
     * @param message Error message from the remote HTTP server.
     */
    constructor(method: "GET" | "DELETE" | "POST" | "PUT" | "PATCH" | "HEAD", path: string, status: number, headers: Record<string, string | string[]>, message: string);
    /**
     * `HttpError` to JSON.
     *
     * When you call `JSON.stringify()` function on current `HttpError` instance,
     * this `HttpError.toJSON()` method would be automatically called.
     *
     * Also, if response body from the remote HTTP server forms a JSON object,
     * this `HttpError.toJSON()` method would be useful because it returns the
     * parsed JSON object about the {@link message} property.
     *
     * @template T Expected type of the response body.
     * @returns JSON object of the `HttpError`.
     */
    toJSON<T>(): HttpError.IProps<T>;
}
export declare namespace HttpError {
    /**
     * Returned type of {@link HttpError.toJSON} method.
     */
    interface IProps<T> {
        method: "GET" | "DELETE" | "POST" | "PUT" | "PATCH" | "HEAD";
        path: string;
        status: number;
        headers: Record<string, string | string[]>;
        message: T;
    }
}
