"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpMigrateRouteAccessor = void 0;
const EndpointUtil_1 = require("../../utils/EndpointUtil");
const Escaper_1 = require("../../utils/Escaper");
const MapUtil_1 = require("../../utils/MapUtil");
var HttpMigrateRouteAccessor;
(function (HttpMigrateRouteAccessor) {
    HttpMigrateRouteAccessor.overwrite = (routes) => {
        const predefined = getPredefinedAccessors(routes);
        const dict = collect((op) => op.emendedPath
            .split("/")
            .filter((str) => !!str.length && str[0] !== ":")
            .map(EndpointUtil_1.EndpointUtil.normalize)
            .map((str) => (Escaper_1.Escaper.variable(str) ? str : `_${str}`)))(routes);
        for (const props of dict.values())
            props.entries.forEach((entry, i) => {
                entry.alias = EndpointUtil_1.EndpointUtil.escapeDuplicate([
                    ...props.children,
                    ...props.entries.filter((_, j) => i !== j).map((e) => e.alias),
                ].map(EndpointUtil_1.EndpointUtil.normalize))(EndpointUtil_1.EndpointUtil.normalize(entry.alias));
                const parameters = [
                    ...entry.route.parameters,
                    ...(entry.route.body ? [entry.route.body] : []),
                    ...(entry.route.headers ? [entry.route.headers] : []),
                    ...(entry.route.query ? [entry.route.query] : []),
                ];
                parameters.forEach((p, i) => (p.key = EndpointUtil_1.EndpointUtil.escapeDuplicate([
                    "connection",
                    entry.alias,
                    ...parameters.filter((_, j) => i !== j).map((y) => y.key),
                ])(p.key)));
                const accessor = entry.route.operation()["x-samchon-accessor"];
                if (accessor !== undefined && predefined.get(accessor.join(".")) === 1)
                    entry.route.accessor = accessor;
                else
                    entry.route.accessor = [...props.namespace, entry.alias];
            });
    };
    const collect = (getter) => (routes) => {
        const dict = new Map();
        for (const r of routes) {
            const namespace = getter(r);
            let last = MapUtil_1.MapUtil.take(dict)(namespace.join("."))(() => ({
                namespace,
                children: new Set(),
                entries: [],
            }));
            last.entries.push({
                route: r,
                alias: getName(r),
            });
            namespace.slice(0, -1).forEach((_i, i, array) => {
                const partial = namespace.slice(0, array.length - i);
                const element = MapUtil_1.MapUtil.take(dict)(partial.join("."))(() => ({
                    namespace: partial,
                    children: new Set(),
                    entries: [],
                }));
                element.children.add(last.namespace.at(-1));
            });
            const top = MapUtil_1.MapUtil.take(dict)("")(() => ({
                namespace: [],
                children: new Set(),
                entries: [],
            }));
            if (namespace.length)
                top.children.add(namespace[0]);
        }
        return dict;
    };
    const getName = (op) => {
        const method = op.method === "delete" ? "erase" : op.method;
        if (op.parameters.length === 0)
            return method;
        return (method +
            "By" +
            op.parameters.map((p) => EndpointUtil_1.EndpointUtil.capitalize(p.key)).join("And"));
    };
    const getPredefinedAccessors = (routes) => {
        var _a;
        const dict = new Map();
        for (const r of routes) {
            const accessor = (_a = r.operation()["x-samchon-accessor"]) === null || _a === void 0 ? void 0 : _a.join(".");
            if (accessor === undefined)
                continue;
            else if (dict.has(accessor))
                dict.set(accessor, dict.get(accessor) + 1);
            else
                dict.set(accessor, 1);
        }
        return dict;
    };
})(HttpMigrateRouteAccessor || (exports.HttpMigrateRouteAccessor = HttpMigrateRouteAccessor = {}));
