"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpMigrateApplicationComposer = void 0;
const EndpointUtil_1 = require("../../utils/EndpointUtil");
const HttpMigrateRouteAccessor_1 = require("./HttpMigrateRouteAccessor");
const HttpMigrateRouteComposer_1 = require("./HttpMigrateRouteComposer");
var HttpMigrateApplicationComposer;
(function (HttpMigrateApplicationComposer) {
    HttpMigrateApplicationComposer.compose = (document) => {
        var _a, _b;
        const errors = [];
        const entire = Object.entries(Object.assign(Object.assign({}, ((_a = document.paths) !== null && _a !== void 0 ? _a : {})), ((_b = document.webhooks) !== null && _b !== void 0 ? _b : {})))
            .map(([path, collection]) => ["head", "get", "post", "put", "patch", "delete"]
            .filter((method) => collection[method] !== undefined)
            .map((method) => {
            const operation = collection[method];
            const migrated = HttpMigrateRouteComposer_1.HttpMigrateRouteComposer.compose({
                document,
                method,
                path,
                emendedPath: EndpointUtil_1.EndpointUtil.reJoinWithDecimalParameters(path),
                operation,
            });
            if (Array.isArray(migrated)) {
                errors.push({
                    method,
                    path,
                    operation: () => operation,
                    messages: migrated,
                });
                return null;
            }
            return migrated;
        }))
            .flat();
        const operations = entire.filter((o) => !!o);
        HttpMigrateRouteAccessor_1.HttpMigrateRouteAccessor.overwrite(operations);
        return {
            document: () => document,
            routes: operations,
            errors,
        };
    };
})(HttpMigrateApplicationComposer || (exports.HttpMigrateApplicationComposer = HttpMigrateApplicationComposer = {}));
