import { OpenApi } from "../../OpenApi";
import { ILlmFunction } from "../../structures/ILlmFunction";
import { ILlmSchemaV3_1 } from "../../structures/ILlmSchemaV3_1";
import { IOpenApiSchemaError } from "../../structures/IOpenApiSchemaError";
import { IResult } from "../../structures/IResult";
export declare namespace LlmSchemaV3_1Composer {
    const parameters: (props: {
        config: ILlmSchemaV3_1.IConfig;
        components: OpenApi.IComponents;
        schema: OpenApi.IJsonSchema.IObject | OpenApi.IJsonSchema.IReference;
        errors?: string[];
        /** @internal */
        validate?: (input: OpenApi.IJsonSchema, accessor: string) => IOpenApiSchemaError.IReason[];
        accessor?: string;
        refAccessor?: string;
    }) => IResult<ILlmSchemaV3_1.IParameters, IOpenApiSchemaError>;
    const schema: (props: {
        config: ILlmSchemaV3_1.IConfig;
        components: OpenApi.IComponents;
        $defs: Record<string, ILlmSchemaV3_1>;
        schema: OpenApi.IJsonSchema;
        /** @internal */
        validate?: (input: OpenApi.IJsonSchema, accessor: string) => IOpenApiSchemaError.IReason[];
        accessor?: string;
        refAccessor?: string;
    }) => IResult<ILlmSchemaV3_1, IOpenApiSchemaError>;
    const separateParameters: (props: {
        parameters: ILlmSchemaV3_1.IParameters;
        predicate: (schema: ILlmSchemaV3_1) => boolean;
        convention?: (key: string, type: "llm" | "human") => string;
    }) => ILlmFunction.ISeparated<"3.1">;
    const invert: (props: {
        components: OpenApi.IComponents;
        schema: ILlmSchemaV3_1;
        $defs: Record<string, ILlmSchemaV3_1>;
    }) => OpenApi.IJsonSchema;
}
