import { OpenApi } from "../../OpenApi";
import { ILlmFunction } from "../../structures/ILlmFunction";
import { ILlmSchemaV3 } from "../../structures/ILlmSchemaV3";
import { IOpenApiSchemaError } from "../../structures/IOpenApiSchemaError";
import { IResult } from "../../structures/IResult";
export declare namespace LlmSchemaV3Composer {
    const parameters: (props: {
        config: ILlmSchemaV3.IConfig;
        components: OpenApi.IComponents;
        schema: OpenApi.IJsonSchema.IObject | OpenApi.IJsonSchema.IReference;
        /** @internal */
        validate?: (schema: OpenApi.IJsonSchema, accessor: string) => IOpenApiSchemaError.IReason[];
        accessor?: string;
        refAccessor?: string;
    }) => IResult<ILlmSchemaV3.IParameters, IOpenApiSchemaError>;
    const schema: (props: {
        config: ILlmSchemaV3.IConfig;
        components: OpenApi.IComponents;
        schema: OpenApi.IJsonSchema;
        /** @internal */
        validate?: (schema: OpenApi.IJsonSchema, accessor: string) => IOpenApiSchemaError.IReason[];
        accessor?: string;
        refAccessor?: string;
    }) => IResult<ILlmSchemaV3, IOpenApiSchemaError>;
    const separateParameters: (props: {
        predicate: (schema: ILlmSchemaV3) => boolean;
        parameters: ILlmSchemaV3.IParameters;
    }) => ILlmFunction.ISeparated<"3.0">;
    const invert: (props: {
        schema: ILlmSchemaV3;
    }) => OpenApi.IJsonSchema;
}
