import { OpenApiTypeChecker } from "../../utils/OpenApiTypeChecker.mjs";

var LlmParametersFinder;

(function(LlmParametersFinder) {
    LlmParametersFinder.parameters = props => {
        const entity = OpenApiTypeChecker.unreference(props);
        if (entity.success === false) return entity; else if (OpenApiTypeChecker.isObject(entity.value) === false) return reportError({
            ...props,
            message: "LLM only accepts object type as parameters."
        }); else if (!!entity.value.additionalProperties) return reportError({
            ...props,
            message: "LLM does not allow additional properties on parameters."
        });
        return {
            success: true,
            value: entity.value
        };
    };
    const reportError = props => ({
        success: false,
        error: {
            method: props.method,
            message: `failed to compose LLM schema.`,
            reasons: [ {
                schema: props.schema,
                message: props.message,
                accessor: props.accessor ?? "$input.schema"
            } ]
        }
    });
})(LlmParametersFinder || (LlmParametersFinder = {}));

export { LlmParametersFinder };
//# sourceMappingURL=LlmParametersComposer.mjs.map
