import { OpenApiExclusiveEmender } from "../../utils/OpenApiExclusiveEmender.mjs";

var LlmDescriptionInverter;

(function(LlmDescriptionInverter) {
    LlmDescriptionInverter.numeric = description => {
        if (description === undefined) return {};
        const lines = description.split("\n");
        return OpenApiExclusiveEmender.emend({
            minimum: find({
                type: "number",
                name: "minimum",
                lines
            }),
            maximum: find({
                type: "number",
                name: "maximum",
                lines
            }),
            exclusiveMinimum: find({
                type: "number",
                name: "exclusiveMinimum",
                lines
            }),
            exclusiveMaximum: find({
                type: "number",
                name: "exclusiveMaximum",
                lines
            }),
            multipleOf: find({
                type: "number",
                name: "multipleOf",
                lines
            }),
            description: describe(lines, [ "minimum", "maximum", "exclusiveMinimum", "exclusiveMaximum", "multipleOf" ])
        });
    };
    LlmDescriptionInverter.string = description => {
        if (description === undefined) return {};
        const lines = description.split("\n");
        return {
            format: find({
                type: "string",
                name: "format",
                lines
            }),
            pattern: find({
                type: "string",
                name: "pattern",
                lines
            }),
            contentMediaType: find({
                type: "string",
                name: "contentMediaType",
                lines
            }),
            minLength: find({
                type: "number",
                name: "minLength",
                lines
            }),
            maxLength: find({
                type: "number",
                name: "maxLength",
                lines
            }),
            description: describe(lines, [ "format", "pattern", "contentMediaType", "minLength", "maxLength" ])
        };
    };
    LlmDescriptionInverter.array = description => {
        if (description === undefined) return {};
        const lines = description.split("\n");
        return {
            minItems: find({
                type: "number",
                name: "minItems",
                lines
            }),
            maxItems: find({
                type: "number",
                name: "maxItems",
                lines
            }),
            uniqueItems: find({
                type: "boolean",
                name: "uniqueItems",
                lines
            }),
            description: describe(lines, [ "minItems", "maxItems", "uniqueItems" ])
        };
    };
    const find = props => {
        if (props.type === "boolean") return props.lines.some((line => line.startsWith(`@${props.name}`))) ? true : undefined;
        for (const line of props.lines) {
            if (line.startsWith(`@${props.name} `) === false) continue;
            const value = line.replace(`@${props.name} `, "").trim();
            if (props.type === "number") return isNaN(Number(value)) ? undefined : Number(value);
            return value;
        }
        return undefined;
    };
    const describe = (lines, tags) => {
        const ret = trimArray(lines.map((str => str.trim())).filter((str => tags.every((tag => str.startsWith(`@${tag}`) === false))))).join("\n");
        return ret.length === 0 ? undefined : ret;
    };
    const trimArray = array => {
        let first = 0;
        let last = array.length - 1;
        for (;first < array.length; ++first) if (array[first].trim().length !== 0) break;
        for (;last >= 0; --last) if (array[last].trim().length !== 0) break;
        return array.slice(first, last + 1);
    };
})(LlmDescriptionInverter || (LlmDescriptionInverter = {}));

export { LlmDescriptionInverter };
//# sourceMappingURL=LlmDescriptionInverter.mjs.map
