"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeminiSchemaComposer = void 0;
const LlmTypeCheckerV3_1 = require("../../utils/LlmTypeCheckerV3");
const OpenApiTypeChecker_1 = require("../../utils/OpenApiTypeChecker");
const LlmParametersComposer_1 = require("./LlmParametersComposer");
const LlmSchemaV3Composer_1 = require("./LlmSchemaV3Composer");
var GeminiSchemaComposer;
(function (GeminiSchemaComposer) {
    /**
     * @internal
     */
    GeminiSchemaComposer.IS_DEFS = false;
    GeminiSchemaComposer.parameters = (props) => {
        const entity = LlmParametersComposer_1.LlmParametersFinder.parameters(Object.assign(Object.assign({}, props), { method: "GeminiSchemaComposer.parameters" }));
        if (entity.success === false)
            return entity;
        return GeminiSchemaComposer.schema(props);
    };
    GeminiSchemaComposer.schema = (props) => {
        // TRANSFORM TO LLM SCHEMA OF V3.0
        const result = LlmSchemaV3Composer_1.LlmSchemaV3Composer.schema(Object.assign(Object.assign({}, props), { config: {
                recursive: props.config.recursive,
                constraint: false,
            }, validate: (next, accessor) => {
                if (OpenApiTypeChecker_1.OpenApiTypeChecker.isObject(next)) {
                    if (!!next.additionalProperties)
                        return [
                            {
                                schema: next,
                                accessor: `${accessor}.additionalProperties`,
                                message: "Gemini does not allow additionalProperties.",
                            },
                        ];
                }
                else if (OpenApiTypeChecker_1.OpenApiTypeChecker.isOneOf(next) &&
                    isOneOf(props.components)(next))
                    return [
                        {
                            schema: next,
                            accessor: accessor,
                            message: "Gemini does not allow union type.",
                        },
                    ];
                return [];
            } }));
        if (result.success === false)
            return result;
        // SPECIALIZATIONS
        LlmTypeCheckerV3_1.LlmTypeCheckerV3.visit({
            schema: result.value,
            closure: (v) => {
                if (v.title !== undefined) {
                    if (v.description === undefined)
                        v.description = v.title;
                    else {
                        const title = v.title.endsWith(".")
                            ? v.title.substring(0, v.title.length - 1)
                            : v.title;
                        v.description = v.description.startsWith(title)
                            ? v.description
                            : `${title}.\n\n${v.description}`;
                    }
                    delete v.title;
                }
                if (LlmTypeCheckerV3_1.LlmTypeCheckerV3.isObject(v) &&
                    v.additionalProperties !== undefined) {
                    delete v.additionalProperties;
                }
            },
        });
        // DO NOT ALLOW UNION TYPE
        return result;
    };
    GeminiSchemaComposer.separateParameters = (props) => {
        const separated = LlmSchemaV3Composer_1.LlmSchemaV3Composer.separateParameters(props);
        return separated;
    };
    GeminiSchemaComposer.invert = (props) => LlmSchemaV3Composer_1.LlmSchemaV3Composer.invert(props);
})(GeminiSchemaComposer || (exports.GeminiSchemaComposer = GeminiSchemaComposer = {}));
const isOneOf = (components) => (schema) => {
    const union = [];
    const already = new Set();
    const visit = (schema) => {
        var _a;
        if (OpenApiTypeChecker_1.OpenApiTypeChecker.isBoolean(schema) ||
            OpenApiTypeChecker_1.OpenApiTypeChecker.isInteger(schema) ||
            OpenApiTypeChecker_1.OpenApiTypeChecker.isNumber(schema) ||
            OpenApiTypeChecker_1.OpenApiTypeChecker.isString(schema))
            union.push(Object.assign({}, schema));
        else if (OpenApiTypeChecker_1.OpenApiTypeChecker.isArray(schema) ||
            OpenApiTypeChecker_1.OpenApiTypeChecker.isTuple(schema) ||
            OpenApiTypeChecker_1.OpenApiTypeChecker.isObject(schema))
            union.push(schema);
        else if (OpenApiTypeChecker_1.OpenApiTypeChecker.isOneOf(schema))
            schema.oneOf.forEach(visit);
        else if (OpenApiTypeChecker_1.OpenApiTypeChecker.isReference(schema)) {
            if (already.has(schema.$ref))
                union.push(schema);
            else {
                already.add(schema.$ref);
                const target = (_a = components.schemas) === null || _a === void 0 ? void 0 : _a[schema.$ref.split("/").pop()];
                if (target === undefined)
                    union.push(schema);
                else
                    visit(target);
            }
        }
    };
    const visitConstant = (schema) => {
        const insert = (value) => {
            var _a;
            const matched = union.find((u) => u.type === typeof value);
            if (matched !== undefined) {
                (_a = matched.enum) !== null && _a !== void 0 ? _a : (matched.enum = []);
                matched.enum.push(value);
            }
            else
                union.push({ type: typeof value, enum: [value] });
        };
        if (OpenApiTypeChecker_1.OpenApiTypeChecker.isConstant(schema))
            insert(schema.const);
        else if (OpenApiTypeChecker_1.OpenApiTypeChecker.isOneOf(schema))
            for (const u of schema.oneOf)
                if (OpenApiTypeChecker_1.OpenApiTypeChecker.isConstant(u))
                    insert(u.const);
    };
    visit(schema);
    visitConstant(schema);
    return union.length > 1;
};
