import { OpenApi } from "../../OpenApi";
import { IGeminiSchema } from "../../structures/IGeminiSchema";
import { ILlmFunction } from "../../structures/ILlmFunction";
import { IOpenApiSchemaError } from "../../structures/IOpenApiSchemaError";
import { IResult } from "../../structures/IResult";
export declare namespace GeminiSchemaComposer {
    const parameters: (props: {
        config: IGeminiSchema.IConfig;
        components: OpenApi.IComponents;
        schema: OpenApi.IJsonSchema.IObject | OpenApi.IJsonSchema.IReference;
        accessor?: string;
        refAccessor?: string;
    }) => IResult<IGeminiSchema.IParameters, IOpenApiSchemaError>;
    const schema: (props: {
        config: IGeminiSchema.IConfig;
        components: OpenApi.IComponents;
        schema: OpenApi.IJsonSchema;
        accessor?: string;
        refAccessor?: string;
    }) => IResult<IGeminiSchema, IOpenApiSchemaError>;
    const separateParameters: (props: {
        predicate: (schema: IGeminiSchema) => boolean;
        parameters: IGeminiSchema.IParameters;
    }) => ILlmFunction.ISeparated<"gemini">;
    const invert: (props: {
        schema: IGeminiSchema;
    }) => OpenApi.IJsonSchema;
}
