import { IChatGptSchema } from "../structures/IChatGptSchema";
import { IClaudeSchema } from "../structures/IClaudeSchema";
import { IGeminiSchema } from "../structures/IGeminiSchema";
import { ILlamaSchema } from "../structures/ILlamaSchema";
import { ILlmSchema } from "../structures/ILlmSchema";
import { ILlmSchemaV3 } from "../structures/ILlmSchemaV3";
import { ILlmSchemaV3_1 } from "../structures/ILlmSchemaV3_1";
import { ChatGptTypeChecker } from "../utils/ChatGptTypeChecker";
import { ClaudeTypeChecker } from "../utils/ClaudeTypeChecker";
import { GeminiTypeChecker } from "../utils/GeminiTypeChecker";
import { LlmTypeCheckerV3 } from "../utils/LlmTypeCheckerV3";
export declare namespace LlmSchemaComposer {
    const parameters: <Model extends ILlmSchema.Model>(model: Model) => {
        chatgpt: (props: {
            config: IChatGptSchema.IConfig;
            components: import("..").OpenApi.IComponents;
            schema: import("..").OpenApi.IJsonSchema.IObject | import("..").OpenApi.IJsonSchema.IReference;
            accessor?: string;
            refAccessor?: string;
        }) => import("..").IResult<IChatGptSchema.IParameters, import("..").IOpenApiSchemaError>;
        claude: (props: {
            config: IClaudeSchema.IConfig;
            components: import("..").OpenApi.IComponents;
            schema: import("..").OpenApi.IJsonSchema.IObject | import("..").OpenApi.IJsonSchema.IReference;
            accessor?: string;
            refAccessor?: string;
        }) => import("..").IResult<IClaudeSchema.IParameters, import("..").IOpenApiSchemaError>;
        gemini: (props: {
            config: IGeminiSchema.IConfig;
            components: import("..").OpenApi.IComponents;
            schema: import("..").OpenApi.IJsonSchema.IObject | import("..").OpenApi.IJsonSchema.IReference;
            accessor?: string;
            refAccessor?: string;
        }) => import("..").IResult<IGeminiSchema.IParameters, import("..").IOpenApiSchemaError>;
        llama: (props: {
            config: ILlamaSchema.IConfig;
            components: import("..").OpenApi.IComponents;
            schema: import("..").OpenApi.IJsonSchema.IObject | import("..").OpenApi.IJsonSchema.IReference;
        }) => import("..").IResult<ILlamaSchema.IParameters, import("..").IOpenApiSchemaError>;
        "3.0": (props: {
            config: ILlmSchemaV3.IConfig;
            components: import("..").OpenApi.IComponents;
            schema: import("..").OpenApi.IJsonSchema.IObject | import("..").OpenApi.IJsonSchema.IReference;
            validate?: (schema: import("..").OpenApi.IJsonSchema, accessor: string) => import("..").IOpenApiSchemaError.IReason[];
            accessor?: string;
            refAccessor?: string;
        }) => import("..").IResult<ILlmSchemaV3.IParameters, import("..").IOpenApiSchemaError>;
        "3.1": (props: {
            config: ILlmSchemaV3_1.IConfig;
            components: import("..").OpenApi.IComponents;
            schema: import("..").OpenApi.IJsonSchema.IObject | import("..").OpenApi.IJsonSchema.IReference;
            errors?: string[];
            validate?: (input: import("..").OpenApi.IJsonSchema, accessor: string) => import("..").IOpenApiSchemaError.IReason[];
            accessor?: string;
            refAccessor?: string;
        }) => import("..").IResult<ILlmSchemaV3_1.IParameters, import("..").IOpenApiSchemaError>;
    }[Model];
    const schema: <Model extends ILlmSchema.Model>(model: Model) => {
        chatgpt: (props: {
            config: IChatGptSchema.IConfig;
            components: import("..").OpenApi.IComponents;
            $defs: Record<string, IChatGptSchema>;
            schema: import("..").OpenApi.IJsonSchema;
            accessor?: string;
            refAccessor?: string;
        }) => import("..").IResult<IChatGptSchema, import("..").IOpenApiSchemaError>;
        claude: (props: {
            config: IClaudeSchema.IConfig;
            components: import("..").OpenApi.IComponents;
            $defs: Record<string, IClaudeSchema>;
            schema: import("..").OpenApi.IJsonSchema;
            accessor?: string;
            refAccessor?: string;
        }) => import("..").IResult<IClaudeSchema, import("..").IOpenApiSchemaError>;
        gemini: (props: {
            config: IGeminiSchema.IConfig;
            components: import("..").OpenApi.IComponents;
            schema: import("..").OpenApi.IJsonSchema;
            accessor?: string;
            refAccessor?: string;
        }) => import("..").IResult<IGeminiSchema, import("..").IOpenApiSchemaError>;
        llama: (props: {
            config: ILlamaSchema.IConfig;
            components: import("..").OpenApi.IComponents;
            $defs: Record<string, ILlamaSchema>;
            schema: import("..").OpenApi.IJsonSchema;
        }) => import("..").IResult<ILlamaSchema, import("..").IOpenApiSchemaError>;
        "3.0": (props: {
            config: ILlmSchemaV3.IConfig;
            components: import("..").OpenApi.IComponents;
            schema: import("..").OpenApi.IJsonSchema;
            validate?: (schema: import("..").OpenApi.IJsonSchema, accessor: string) => import("..").IOpenApiSchemaError.IReason[];
            accessor?: string;
            refAccessor?: string;
        }) => import("..").IResult<ILlmSchemaV3, import("..").IOpenApiSchemaError>;
        "3.1": (props: {
            config: ILlmSchemaV3_1.IConfig;
            components: import("..").OpenApi.IComponents;
            $defs: Record<string, ILlmSchemaV3_1>;
            schema: import("..").OpenApi.IJsonSchema;
            validate?: (input: import("..").OpenApi.IJsonSchema, accessor: string) => import("..").IOpenApiSchemaError.IReason[];
            accessor?: string;
            refAccessor?: string;
        }) => import("..").IResult<ILlmSchemaV3_1, import("..").IOpenApiSchemaError>;
    }[Model];
    const defaultConfig: <Model extends ILlmSchema.Model>(model: Model) => {
        chatgpt: {
            reference: false;
            strict: false;
        };
        claude: {
            reference: false;
        };
        gemini: {
            recursive: number;
        };
        llama: {
            reference: false;
        };
        "3.0": {
            constraint: true;
            recursive: number;
        };
        "3.1": {
            constraint: true;
            reference: false;
        };
    }[Model];
    const typeChecker: <Model extends ILlmSchema.Model>(model: Model) => {
        chatgpt: typeof ChatGptTypeChecker;
        claude: typeof ClaudeTypeChecker;
        gemini: typeof GeminiTypeChecker;
        llama: typeof ClaudeTypeChecker;
        "3.0": typeof LlmTypeCheckerV3;
        "3.1": typeof ClaudeTypeChecker;
    }[Model];
    const separateParameters: <Model extends ILlmSchema.Model>(model: Model) => {
        chatgpt: (props: {
            parameters: IChatGptSchema.IParameters;
            predicate: (schema: IChatGptSchema) => boolean;
            convention?: (key: string, type: "llm" | "human") => string;
        }) => import("..").ILlmFunction.ISeparated<"chatgpt">;
        claude: (props: {
            parameters: IClaudeSchema.IParameters;
            predicate: (schema: IClaudeSchema) => boolean;
            convention?: (key: string, type: "llm" | "human") => string;
        }) => import("..").ILlmFunction.ISeparated<"claude">;
        gemini: (props: {
            predicate: (schema: IGeminiSchema) => boolean;
            parameters: IGeminiSchema.IParameters;
        }) => import("..").ILlmFunction.ISeparated<"gemini">;
        llama: (props: {
            parameters: ILlamaSchema.IParameters;
            predicate: (schema: ILlamaSchema) => boolean;
            convention?: (key: string, type: "llm" | "human") => string;
        }) => import("..").ILlmFunction.ISeparated<"llama">;
        "3.0": (props: {
            predicate: (schema: ILlmSchemaV3) => boolean;
            parameters: ILlmSchemaV3.IParameters;
        }) => import("..").ILlmFunction.ISeparated<"3.0">;
        "3.1": (props: {
            parameters: ILlmSchemaV3_1.IParameters;
            predicate: (schema: ILlmSchemaV3_1) => boolean;
            convention?: (key: string, type: "llm" | "human") => string;
        }) => import("..").ILlmFunction.ISeparated<"3.1">;
    }[Model];
    const invert: <Model extends ILlmSchema.Model>(model: Model) => {
        chatgpt: (props: {
            components: import("..").OpenApi.IComponents;
            schema: IChatGptSchema;
            $defs: Record<string, IChatGptSchema>;
        }) => import("..").OpenApi.IJsonSchema;
        claude: (props: {
            components: import("..").OpenApi.IComponents;
            schema: IClaudeSchema;
            $defs: Record<string, IClaudeSchema>;
        }) => import("..").OpenApi.IJsonSchema;
        gemini: (props: {
            schema: IGeminiSchema;
        }) => import("..").OpenApi.IJsonSchema;
        llama: (props: {
            components: import("..").OpenApi.IComponents;
            schema: ILlamaSchema;
            $defs: Record<string, ILlamaSchema>;
        }) => import("..").OpenApi.IJsonSchema;
        "3.0": (props: {
            schema: ILlmSchemaV3;
        }) => import("..").OpenApi.IJsonSchema;
        "3.1": (props: {
            components: import("..").OpenApi.IComponents;
            schema: ILlmSchemaV3_1;
            $defs: Record<string, ILlmSchemaV3_1>;
        }) => import("..").OpenApi.IJsonSchema;
    }[Model];
}
