import { OpenApi } from "./OpenApi.mjs";

import { HttpMigrateApplicationComposer } from "./composers/migrate/HttpMigrateApplicationComposer.mjs";

import { HttpMigrateRouteFetcher } from "./http/HttpMigrateRouteFetcher.mjs";

var HttpMigration;

(function(HttpMigration) {
    HttpMigration.application = document => HttpMigrateApplicationComposer.compose(OpenApi.convert(document));
    HttpMigration.execute = props => HttpMigrateRouteFetcher.execute(props);
    HttpMigration.propagate = props => HttpMigrateRouteFetcher.propagate(props);
})(HttpMigration || (HttpMigration = {}));

export { HttpMigration };
//# sourceMappingURL=HttpMigration.mjs.map
