import { HttpMigration } from "./HttpMigration.mjs";

import { HttpLlmComposer } from "./composers/HttpLlmApplicationComposer.mjs";

import { LlmSchemaComposer } from "./composers/LlmSchemaComposer.mjs";

import { HttpLlmFunctionFetcher } from "./http/HttpLlmFunctionFetcher.mjs";

import { LlmDataMerger } from "./utils/LlmDataMerger.mjs";

var HttpLlm;

(function(HttpLlm) {
    HttpLlm.application = props => {
        const migrate = HttpMigration.application(props.document);
        const defaultConfig = LlmSchemaComposer.defaultConfig(props.model);
        return HttpLlmComposer.application({
            migrate,
            model: props.model,
            options: {
                ...Object.fromEntries(Object.entries(defaultConfig).map((([key, value]) => [ key, props.options?.[key] ?? value ]))),
                separate: props.options?.separate ?? null,
                maxLength: props.options?.maxLength ?? null
            }
        });
    };
    HttpLlm.execute = props => HttpLlmFunctionFetcher.execute(props);
    HttpLlm.propagate = props => HttpLlmFunctionFetcher.propagate(props);
    HttpLlm.mergeParameters = props => LlmDataMerger.parameters(props);
    HttpLlm.mergeValue = (x, y) => LlmDataMerger.value(x, y);
})(HttpLlm || (HttpLlm = {}));

export { HttpLlm };
//# sourceMappingURL=HttpLlm.mjs.map
