import { HttpClient, HttpBackend } from '@angular/common/http';
import * as i0 from '@angular/core';
import { InjectionToken, inject, Injectable } from '@angular/core';
import { TranslateLoader } from '@ngx-translate/core';

const TRANSLATE_HTTP_LOADER_CONFIG = new InjectionToken("TRANSLATE_HTTP_LOADER_CONFIG");
class TranslateHttpLoader {
    http;
    config;
    constructor() {
        this.config = {
            prefix: "/assets/i18n/",
            suffix: ".json",
            enforceLoading: false,
            useHttpBackend: false,
            ...inject(TRANSLATE_HTTP_LOADER_CONFIG),
        };
        this.http = this.config.useHttpBackend
            ? new HttpClient(inject(HttpBackend))
            : inject(HttpClient);
    }
    /**
     * Gets the translations from the server
     */
    getTranslation(lang) {
        const cacheBuster = this.config.enforceLoading ? `?enforceLoading=${Date.now()}` : "";
        return this.http.get(`${this.config.prefix}${lang}${this.config.suffix}${cacheBuster}`);
    }
    static ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "20.0.6", ngImport: i0, type: TranslateHttpLoader, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
    static ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "20.0.6", ngImport: i0, type: TranslateHttpLoader });
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "20.0.6", ngImport: i0, type: TranslateHttpLoader, decorators: [{
            type: Injectable
        }], ctorParameters: () => [] });
function provideTranslateHttpLoader(config = {}) {
    const useBackend = config.useHttpBackend ?? false;
    return [
        {
            provide: TRANSLATE_HTTP_LOADER_CONFIG,
            useValue: config,
        },
        {
            provide: TranslateLoader,
            useClass: TranslateHttpLoader,
            deps: [useBackend ? HttpBackend : HttpClient, TRANSLATE_HTTP_LOADER_CONFIG],
        },
    ];
}

/**
 * Generated bundle index. Do not edit.
 */

export { TRANSLATE_HTTP_LOADER_CONFIG, TranslateHttpLoader, provideTranslateHttpLoader };
//# sourceMappingURL=ngx-translate-http-loader.mjs.map
