import { Observable, Subscription } from 'rxjs';
import * as i0 from '@angular/core';
import { InjectionToken, AfterViewChecked, OnDestroy, PipeTransform, Provider, Type, ClassProvider, ModuleWithProviders } from '@angular/core';

declare function _<T extends string | string[]>(key: T): T;

type InterpolateFunction = (params?: InterpolationParameters) => string;
declare abstract class TranslateParser {
    /**
     * Interpolates a string to replace parameters
     * "This is a {{ key }}" ==> "This is a value", with params = { key: "value" }
     * @param expr
     * @param params
     */
    abstract interpolate(expr: InterpolateFunction | string, params?: InterpolationParameters): string | undefined;
}
declare class TranslateDefaultParser extends TranslateParser {
    templateMatcher: RegExp;
    interpolate(expr: InterpolateFunction | string, params?: InterpolationParameters): string | undefined;
    protected interpolateFunction(fn: InterpolateFunction, params?: InterpolationParameters): string;
    protected interpolateString(expr: string, params?: InterpolationParameters): string;
    /**
     * Returns the replacement for an interpolation parameter
     * @params:
     */
    protected getInterpolationReplacement(params: InterpolationParameters, key: string): string | undefined;
    /**
     * Converts a value into a useful string representation.
     * @param value The value to format.
     * @returns A string representation of the value.
     */
    protected formatValue(value: unknown): string | undefined;
    static ɵfac: i0.ɵɵFactoryDeclaration<TranslateDefaultParser, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<TranslateDefaultParser>;
}

declare abstract class TranslateCompiler {
    abstract compile(value: string, lang: string): InterpolatableTranslation;
    abstract compileTranslations(translations: TranslationObject, lang: string): InterpolatableTranslationObject;
}
/**
 * This compiler is just a placeholder that does nothing; in case you don't need a compiler at all
 */
declare class TranslateNoOpCompiler extends TranslateCompiler {
    compile(value: string, lang: string): string | InterpolateFunction;
    compileTranslations(translations: TranslationObject, lang: string): InterpolatableTranslationObject;
    static ɵfac: i0.ɵɵFactoryDeclaration<TranslateNoOpCompiler, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<TranslateNoOpCompiler>;
}

declare abstract class TranslateLoader {
    abstract getTranslation(lang: string): Observable<TranslationObject>;
}
/**
 * This loader is just a placeholder that does nothing; in case you don't need a loader at all
 */
declare class TranslateNoOpLoader extends TranslateLoader {
    getTranslation(lang: string): Observable<TranslationObject>;
    static ɵfac: i0.ɵɵFactoryDeclaration<TranslateNoOpLoader, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<TranslateNoOpLoader>;
}

/**
 * Configuration object for the translation service.
 *
 * Provides options to customize translation behavior, including setting the primary language,
 * specifying a fallback language, and other deprecated flags for legacy support.
 */
interface TranslateServiceConfig {
    lang?: Language;
    fallbackLang?: Language | null;
    extend: boolean;
}
declare const TRANSLATE_SERVICE_CONFIG: InjectionToken<TranslateServiceConfig>;
type InterpolationParameters = Record<string, any>;
type StrictTranslation = string | StrictTranslation[] | TranslationObject | undefined | null;
type Translation = StrictTranslation | any;
interface TranslationObject {
    [key: string]: StrictTranslation;
}
type InterpolatableTranslation = string | InterpolatableTranslation[] | InterpolateFunction | InterpolatableTranslationObject | undefined | null;
interface InterpolatableTranslationObject {
    [key: string]: InterpolatableTranslation;
}
type Language = string;
interface TranslationChangeEvent {
    translations: InterpolatableTranslationObject;
    lang: string;
}
interface LangChangeEvent {
    lang: string;
    translations: InterpolatableTranslationObject;
}
interface FallbackLangChangeEvent {
    lang: string;
    translations: InterpolatableTranslationObject;
}
/** @deprecated use `FallbackLangChangeEvent` */
type DefaultLangChangeEvent = FallbackLangChangeEvent;
declare abstract class ITranslateService {
    abstract readonly onTranslationChange: Observable<TranslationChangeEvent>;
    abstract readonly onLangChange: Observable<LangChangeEvent>;
    abstract readonly onFallbackLangChange: Observable<FallbackLangChangeEvent>;
    abstract use(lang: Language): Observable<InterpolatableTranslationObject>;
    abstract setFallbackLang(lang: Language): Observable<InterpolatableTranslationObject>;
    abstract getFallbackLang(): Language | null;
    abstract addLangs(languages: Language[]): void;
    abstract getLangs(): readonly Language[];
    abstract reloadLang(lang: Language): Observable<InterpolatableTranslationObject>;
    abstract resetLang(lang: Language): void;
    abstract instant(key: string | string[], interpolateParams?: InterpolationParameters): Translation;
    abstract stream(key: string | string[], interpolateParams?: InterpolationParameters): Observable<Translation>;
    abstract getStreamOnTranslationChange(key: string | string[], interpolateParams?: InterpolationParameters): Observable<Translation>;
    abstract set(key: string, translation: string | TranslationObject, lang?: Language): void;
    abstract get(key: string | string[], interpolateParams?: InterpolationParameters): Observable<Translation>;
    abstract setTranslation(lang: Language, translations: TranslationObject, shouldMerge?: boolean): void;
    abstract getParsedResult(key: string | string[], interpolateParams?: InterpolationParameters): StrictTranslation | Observable<StrictTranslation>;
    abstract getBrowserLang(): Language | undefined;
    abstract getBrowserCultureLang(): Language | undefined;
    /**
     * Returns the current language
     * @deprecated use `getCurrentLang()`
     */
    abstract readonly currentLang: Language;
    /**
     * Returns a list of known languages - either loaded
     * or set by using `addLangs()`
     * @deprecated use `getLangs()`
     */
    abstract readonly langs: readonly Language[];
    /**
     * Sets the fallback language
     * @param lang The language to set
     * @deprecated use `setFallbackLang(lang)`
     */
    abstract setDefaultLang(lang: Language): Observable<InterpolatableTranslationObject>;
    /**
     * Gets the fallback language
     * @deprecated use `getFallbackLang()`
     */
    abstract getDefaultLang(): Language | null;
    /**
     * Returns the fallback language
     * @deprectated use `getFallbackLang()`
     */
    abstract readonly defaultLang: Language | null;
    /**
     * @deprectated use `getFallbackLang()`
     */
    abstract readonly onDefaultLangChange: Observable<DefaultLangChangeEvent>;
}
declare class TranslateService implements ITranslateService {
    private loadingTranslations;
    private pending;
    private _translationRequests;
    private lastUseLanguage;
    currentLoader: TranslateLoader;
    compiler: TranslateCompiler;
    private parser;
    private missingTranslationHandler;
    private store;
    private readonly extend;
    /**
     * An Observable to listen to translation change events
     * onTranslationChange.subscribe((params: TranslationChangeEvent) => {
     *     // do something
     * });
     */
    get onTranslationChange(): Observable<TranslationChangeEvent>;
    /**
     * An Observable to listen to lang change events
     * onLangChange.subscribe((params: LangChangeEvent) => {
     *     // do something
     * });
     */
    get onLangChange(): Observable<LangChangeEvent>;
    /**
     * An Observable to listen to fallback lang change events
     * onFallbackLangChange.subscribe((params: FallbackLangChangeEvent) => {
     *     // do something
     * });
     */
    get onFallbackLangChange(): Observable<FallbackLangChangeEvent>;
    /**
     * @deprecated Use onFallbackLangChange() instead
     */
    get onDefaultLangChange(): Observable<DefaultLangChangeEvent>;
    constructor();
    /**
     * Sets the fallback language to use if a translation is not found in the
     * current language
     */
    setFallbackLang(lang: Language): Observable<InterpolatableTranslationObject>;
    /**
     * Changes the lang currently used
     */
    use(lang: Language): Observable<InterpolatableTranslationObject>;
    /**
     * Retrieves the given translations
     */
    private loadOrExtendLanguage;
    /**
     * Changes the current lang
     */
    private changeLang;
    getCurrentLang(): Language;
    private loadAndCompileTranslations;
    /**
     * Manually sets an object of translations for a given language
     * after passing it through the compiler
     */
    setTranslation(lang: Language, translations: TranslationObject, shouldMerge?: boolean): void;
    getLangs(): readonly Language[];
    /**
     * Add available languages
     */
    addLangs(languages: Language[]): void;
    private getParsedResultForKey;
    /**
     * Gets the fallback language. null if none is defined
     */
    getFallbackLang(): Language | null;
    private getTextToInterpolate;
    private runInterpolation;
    private runInterpolationOnArray;
    private runInterpolationOnDict;
    /**
     * Returns the parsed result of the translations
     */
    getParsedResult(key: string | string[], interpolateParams?: InterpolationParameters): StrictTranslation | Observable<StrictTranslation>;
    private getParsedResultForArray;
    /**
     * Gets the translated value of a key (or an array of keys)
     * @returns the translated key, or an object of translated keys
     */
    get(key: string | string[], interpolateParams?: InterpolationParameters): Observable<Translation>;
    /**
     * Returns a stream of translated values of a key (or an array of keys) which updates
     * whenever the translation changes.
     * @returns A stream of the translated key, or an object of translated keys
     */
    getStreamOnTranslationChange(key: string | string[], interpolateParams?: InterpolationParameters): Observable<Translation>;
    /**
     * Returns a stream of translated values of a key (or an array of keys) which updates
     * whenever the language changes.
     * @returns A stream of the translated key, or an object of translated keys
     */
    stream(key: string | string[], interpolateParams?: InterpolationParameters): Observable<Translation>;
    /**
     * Returns a translation instantly from the internal state of loaded translation.
     * All rules regarding the current language, the preferred language of even fallback languages
     * will be used except any promise handling.
     */
    instant(key: string | string[], interpolateParams?: InterpolationParameters): Translation;
    /**
     * Sets the translated value of a key, after compiling it
     */
    set(key: string, translation: string | TranslationObject, lang?: Language): void;
    /**
     * Allows reloading the lang file from the file
     */
    reloadLang(lang: Language): Observable<InterpolatableTranslationObject>;
    /**
     * Deletes inner translation
     */
    resetLang(lang: Language): void;
    /**
     * Returns the language code name from the browser, e.g. "de"
     */
    static getBrowserLang(): Language | undefined;
    /**
     * Returns the culture language code name from the browser, e.g. "de-DE"
     */
    static getBrowserCultureLang(): Language | undefined;
    getBrowserLang(): Language | undefined;
    getBrowserCultureLang(): Language | undefined;
    /** Deprecations **/
    /**
     * @deprecated use `getFallbackLang()`
     */
    get defaultLang(): Language | null;
    /**
     * The lang currently used
     * @deprecated use `getCurrentLang()`
     */
    get currentLang(): Language;
    /**
     * @deprecated use `getLangs()`
     */
    get langs(): readonly Language[];
    /**
     * Sets the  language to use as a fallback
     * @deprecated use setFallbackLanguage()
     */
    setDefaultLang(lang: Language): Observable<InterpolatableTranslationObject>;
    /**
     * Gets the fallback language used
     * @deprecated use getFallbackLang()
     */
    getDefaultLang(): Language | null;
    static ɵfac: i0.ɵɵFactoryDeclaration<TranslateService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<TranslateService>;
}

interface MissingTranslationHandlerParams {
    /**
     * the key that's missing in translation files
     */
    key: string;
    /**
     * an instance of the service that was unable to translate the key.
     */
    translateService: TranslateService;
    /**
     * interpolation params that were passed along for translating the given key.
     */
    interpolateParams?: object;
}
declare abstract class MissingTranslationHandler {
    /**
     * A function that handles missing translations.
     *
     * @param params context for resolving a missing translation
     * @returns a value or an observable
     *
     * If it returns a value, then this value is used.
     * If it returns an observable, the value returned by this observable will be used (except if the method was "instant").
     * If it returns undefined, the key will be used as a value
     */
    abstract handle(params: MissingTranslationHandlerParams): StrictTranslation | Observable<StrictTranslation>;
}
/**
 * This handler is just a placeholder that does nothing; in case you don't need a missing translation handler at all
 */
declare class DefaultMissingTranslationHandler implements MissingTranslationHandler {
    handle(params: MissingTranslationHandlerParams): string;
    static ɵfac: i0.ɵɵFactoryDeclaration<DefaultMissingTranslationHandler, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<DefaultMissingTranslationHandler>;
}

interface ExtendedNode extends Text {
    originalContent: string;
    currentValue: string;
    lookupKey: string;
    lastKey: string | null;
    data: string;
}
declare class TranslateDirective implements AfterViewChecked, OnDestroy {
    private translateService;
    private element;
    private _ref;
    private key;
    private lastParams?;
    private currentParams?;
    private readonly onLangChangeSub;
    private readonly onFallbackLangChangeSub;
    private readonly onTranslationChangeSub;
    set translate(key: string);
    set translateParams(params: InterpolationParameters);
    constructor();
    ngAfterViewChecked(): void;
    checkNodes(forceUpdate?: boolean, translations?: InterpolatableTranslation): void;
    updateValue(key: string, node: ExtendedNode, translations?: InterpolatableTranslation): void;
    getContent(node: ExtendedNode): string;
    setContent(node: ExtendedNode, content: string): void;
    ngOnDestroy(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<TranslateDirective, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<TranslateDirective, "[translate],[ngx-translate]", never, { "translate": { "alias": "translate"; "required": false; }; "translateParams": { "alias": "translateParams"; "required": false; }; }, {}, never, never, true, never>;
}

declare class TranslatePipe implements PipeTransform, OnDestroy {
    private translate;
    private _ref;
    private value;
    lastKey: string | null;
    lastParams: InterpolationParameters[];
    onTranslationChange: Subscription | undefined;
    onLangChange: Subscription | undefined;
    onFallbackLangChange: Subscription | undefined;
    updateValue(key: string, interpolateParams?: InterpolationParameters, translations?: InterpolatableTranslationObject): void;
    transform(query: string | undefined | null, ...args: any[]): any;
    /**
     * Clean any existing subscription to change events
     */
    private _dispose;
    ngOnDestroy(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<TranslatePipe, never>;
    static ɵpipe: i0.ɵɵPipeDeclaration<TranslatePipe, "translate", true>;
    static ɵprov: i0.ɵɵInjectableDeclaration<TranslatePipe>;
}

type DeepReadonly<T> = {
    readonly [K in keyof T]: T[K] extends object ? DeepReadonly<T[K]> : T[K];
};
declare class TranslateStore {
    private _onTranslationChange;
    private _onLangChange;
    private _onFallbackLangChange;
    private fallbackLang;
    private currentLang;
    private translations;
    private languages;
    getTranslations(language: Language): DeepReadonly<InterpolatableTranslationObject>;
    setTranslations(language: Language, translations: InterpolatableTranslationObject, extend: boolean): void;
    getLanguages(): readonly Language[];
    getCurrentLang(): Language;
    getFallbackLang(): Language | null;
    /**
     * Changes the fallback lang
     */
    setFallbackLang(lang: string, emitChange?: boolean): void;
    setCurrentLang(lang: string, emitChange?: boolean): void;
    /**
     * An Observable to listen to translation change events
     * onTranslationChange.subscribe((params: TranslationChangeEvent) => {
     *     // do something
     * });
     */
    get onTranslationChange(): Observable<TranslationChangeEvent>;
    /**
     * An Observable to listen to lang change events
     * onLangChange.subscribe((params: LangChangeEvent) => {
     *     // do something
     * });
     */
    get onLangChange(): Observable<LangChangeEvent>;
    /**
     * An Observable to listen to fallback lang change events
     * onFallbackLangChange.subscribe((params: FallbackLangChangeEvent) => {
     *     // do something
     * });
     */
    get onFallbackLangChange(): Observable<FallbackLangChangeEvent>;
    addLanguages(languages: Language[]): void;
    hasTranslationFor(lang: string): boolean;
    deleteTranslations(lang: string): void;
    getTranslation(key: string): InterpolatableTranslation;
    protected getValue(language: Language, key: string): InterpolatableTranslation;
    static ɵfac: i0.ɵɵFactoryDeclaration<TranslateStore, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<TranslateStore>;
}

interface TranslateProviders {
    loader?: Provider;
    compiler?: Provider;
    parser?: Provider;
    missingTranslationHandler?: Provider;
}
interface ChildTranslateServiceConfig extends Partial<TranslateProviders> {
    extend?: boolean;
}
interface RootTranslateServiceConfig extends ChildTranslateServiceConfig {
    fallbackLang?: Language;
    lang?: Language;
    useDefaultLang?: boolean;
    defaultLanguage?: Language;
}
declare function provideTranslateLoader(loader: Type<TranslateLoader>): ClassProvider;
declare function provideTranslateCompiler(compiler: Type<TranslateCompiler>): ClassProvider;
declare function provideTranslateParser(parser: Type<TranslateParser>): ClassProvider;
declare function provideMissingTranslationHandler(handler: Type<MissingTranslationHandler>): ClassProvider;
declare function provideTranslateService(config?: RootTranslateServiceConfig): Provider[];
declare function provideChildTranslateService(config?: ChildTranslateServiceConfig): Provider[];
declare function defaultProviders(config: RootTranslateServiceConfig | undefined, provideStore: boolean): Provider[];

interface TranslateModuleConfig extends TranslateProviders {
    isolate?: boolean;
    extend?: boolean;
    fallbackLang?: Language;
    lang?: Language;
    /** @deprecated use fallbackLang */
    defaultLanguage?: string;
    /** @deprecated use fallbackLang */
    useDefaultLang?: boolean;
}
declare class TranslateModule {
    /**
     * Use this method in your root module to provide the TranslateService
     */
    static forRoot(config?: TranslateModuleConfig): ModuleWithProviders<TranslateModule>;
    /**
     * Use this method in your other (non-root) modules to import the directive/pipe
     */
    static forChild(config?: TranslateModuleConfig): ModuleWithProviders<TranslateModule>;
    static ɵfac: i0.ɵɵFactoryDeclaration<TranslateModule, never>;
    static ɵmod: i0.ɵɵNgModuleDeclaration<TranslateModule, never, [typeof TranslatePipe, typeof TranslateDirective], [typeof TranslatePipe, typeof TranslateDirective]>;
    static ɵinj: i0.ɵɵInjectorDeclaration<TranslateModule>;
}

/**
 * Determines if two objects or two values are equivalent.
 *
 * Two objects or values are considered equivalent if at least one of the following is true:
 *
 * * Both objects or values pass `===` comparison.
 * * Both objects or values are of the same type and all of their properties are equal by
 *   comparing them with `equals`.
 *
 * @param o1 Object or value to compare.
 * @param o2 Object or value to compare.
 * @returns true if arguments are equal.
 */
declare function equals(o1: unknown, o2: unknown): boolean;
declare function isDefinedAndNotNull<T>(value: T | null | undefined): value is T;
declare function isDefined<T>(value: T | null | undefined): value is T | null;
declare function isDict(value: unknown): value is InterpolatableTranslationObject;
declare function isObject(value: unknown): value is Record<string, unknown>;
declare function isArray(value: unknown): value is unknown[];
declare function isString(value: unknown): value is string;
declare function isFunction(value: unknown): boolean;
declare function mergeDeep(target: Readonly<unknown>, source: Readonly<unknown>): any;
/**
 * Retrieves a value from a nested object using a dot-separated key path.
 *
 * Example usage:
 * ```ts
 * getValue({ key1: { keyA: 'valueI' }}, 'key1.keyA'); // returns 'valueI'
 * ```
 *
 * @param target The source object from which to retrieve the value.
 * @param key Dot-separated key path specifying the value to retrieve.
 * @returns The value at the specified key path, or `undefined` if not found.
 */
declare function getValue(target: unknown, key: string): unknown;
/**
 * Sets a value on object using a dot separated key.
 * This function modifies the object in place
 * parser.setValue({a:{b:{c: "test"}}}, 'a.b.c', "test2") ==> {a:{b:{c: "test2"}}}
 * @param target an object
 * @param key E.g. "a.b.c"
 * @param value to set
 * @deprecated use insertValue() instead
 */
declare function setValue(target: Record<string, unknown>, key: string, value: unknown): void;
/**
 * Sets a value on object using a dot separated key.
 * Returns a clone of the object without modifying it
 * parser.setValue({a:{b:{c: "test"}}}, 'a.b.c', "test2") ==> {a:{b:{c: "test2"}}}
 * @param target an object
 * @param key E.g. "a.b.c"
 * @param value to set
 */
declare function insertValue<T>(target: Readonly<T>, key: string, value: unknown): T;

export { DefaultMissingTranslationHandler, ITranslateService, MissingTranslationHandler, TRANSLATE_SERVICE_CONFIG, TranslateCompiler, TranslateDefaultParser, TranslateDirective, TranslateLoader, TranslateModule, TranslateNoOpCompiler, TranslateNoOpLoader, TranslateParser, TranslatePipe, TranslateService, TranslateStore, _, defaultProviders, equals, getValue, insertValue, isArray, isDefined, isDefinedAndNotNull, isDict, isFunction, isObject, isString, mergeDeep, provideChildTranslateService, provideMissingTranslationHandler, provideTranslateCompiler, provideTranslateLoader, provideTranslateParser, provideTranslateService, setValue };
export type { ChildTranslateServiceConfig, DeepReadonly, DefaultLangChangeEvent, FallbackLangChangeEvent, InterpolatableTranslation, InterpolatableTranslationObject, InterpolateFunction, InterpolationParameters, LangChangeEvent, Language, MissingTranslationHandlerParams, RootTranslateServiceConfig, StrictTranslation, TranslateModuleConfig, TranslateProviders, TranslateServiceConfig, Translation, TranslationChangeEvent, TranslationObject };
