import * as i0 from '@angular/core';
import { ChangeDetectionStrategy, Component, NgModule } from '@angular/core';
import { FieldType, FormlyMatFormFieldModule } from '@ngx-formly/material/form-field';
import * as i1 from '@angular/forms';
import { ReactiveFormsModule } from '@angular/forms';
import * as i2 from '@angular/material/slider';
import { MatSliderModule } from '@angular/material/slider';
import * as i3 from '@ngx-formly/core';
import { FormlyModule } from '@ngx-formly/core';
import { CommonModule } from '@angular/common';
import { MatCommonModule, MatRippleModule } from '@angular/material/core';

class FormlyFieldSlider extends FieldType {
    constructor() {
        super(...arguments);
        this.defaultOptions = {
            props: {
                hideFieldUnderline: true,
                floatLabel: 'always',
                displayWith: (value) => `${value}`,
            },
        };
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyFieldSlider, deps: null, target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.13", type: FormlyFieldSlider, selector: "formly-field-mat-slider", usesInheritance: true, ngImport: i0, template: `
    <mat-slider
      [id]="id"
      [style.width]="'100%'"
      [formlyAttributes]="field"
      [tabIndex]="props.tabindex"
      [color]="props.color"
      [displayWith]="props.displayWith"
      [max]="props.max"
      [min]="props.min"
      [step]="props.step"
      [discrete]="props.discrete"
      [showTickMarks]="props.showTickMarks"
      [step]="props.step"
      (input)="props.input && props.input(field, $event)"
      (change)="props.change && props.change(field, $event)"
    >
      <input matSliderThumb [formControl]="formControl" [formlyAttributes]="field" />
    </mat-slider>
  `, isInline: true, dependencies: [{ kind: "directive", type: i1.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i1.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i1.FormControlDirective, selector: "[formControl]", inputs: ["formControl", "disabled", "ngModel"], outputs: ["ngModelChange"], exportAs: ["ngForm"] }, { kind: "component", type: i2.MatSlider, selector: "mat-slider", inputs: ["disabled", "discrete", "showTickMarks", "min", "color", "disableRipple", "max", "step", "displayWith"], exportAs: ["matSlider"] }, { kind: "directive", type: i2.MatSliderThumb, selector: "input[matSliderThumb]", inputs: ["value"], outputs: ["valueChange", "dragStart", "dragEnd"], exportAs: ["matSliderThumb"] }, { kind: "directive", type: i3.LegacyFormlyAttributes, selector: "[formlyAttributes]" }], changeDetection: i0.ChangeDetectionStrategy.OnPush }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyFieldSlider, decorators: [{
            type: Component,
            args: [{
                    selector: 'formly-field-mat-slider',
                    template: `
    <mat-slider
      [id]="id"
      [style.width]="'100%'"
      [formlyAttributes]="field"
      [tabIndex]="props.tabindex"
      [color]="props.color"
      [displayWith]="props.displayWith"
      [max]="props.max"
      [min]="props.min"
      [step]="props.step"
      [discrete]="props.discrete"
      [showTickMarks]="props.showTickMarks"
      [step]="props.step"
      (input)="props.input && props.input(field, $event)"
      (change)="props.change && props.change(field, $event)"
    >
      <input matSliderThumb [formControl]="formControl" [formlyAttributes]="field" />
    </mat-slider>
  `,
                    changeDetection: ChangeDetectionStrategy.OnPush,
                }]
        }] });

function withFormlyFieldSlider() {
    return {
        types: [
            {
                name: 'slider',
                component: FormlyFieldSlider,
                wrappers: ['form-field'],
            },
        ],
    };
}

class FormlyMatSliderModule {
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyMatSliderModule, deps: [], target: i0.ɵɵFactoryTarget.NgModule }); }
    static { this.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "14.0.0", version: "18.2.13", ngImport: i0, type: FormlyMatSliderModule, declarations: [FormlyFieldSlider], imports: [CommonModule,
            MatCommonModule,
            MatRippleModule,
            ReactiveFormsModule,
            MatSliderModule,
            FormlyMatFormFieldModule, i3.FormlyModule] }); }
    static { this.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyMatSliderModule, imports: [CommonModule,
            MatCommonModule,
            MatRippleModule,
            ReactiveFormsModule,
            MatSliderModule,
            FormlyMatFormFieldModule,
            FormlyModule.forChild(withFormlyFieldSlider())] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyMatSliderModule, decorators: [{
            type: NgModule,
            args: [{
                    declarations: [FormlyFieldSlider],
                    imports: [
                        CommonModule,
                        MatCommonModule,
                        MatRippleModule,
                        ReactiveFormsModule,
                        MatSliderModule,
                        FormlyMatFormFieldModule,
                        FormlyModule.forChild(withFormlyFieldSlider()),
                    ],
                }]
        }] });

/**
 * Generated bundle index. Do not edit.
 */

export { FormlyFieldSlider, FormlyMatSliderModule, withFormlyFieldSlider };
//# sourceMappingURL=ngx-formly-material-slider.mjs.map
