import * as i0 from '@angular/core';
import { ViewChild, ChangeDetectionStrategy, Component, NgModule } from '@angular/core';
import * as i3 from '@angular/material/select';
import { MatSelect, MatSelectModule } from '@angular/material/select';
import * as i5 from '@ngx-formly/core';
import { ɵobserve as _observe, FormlyModule } from '@ngx-formly/core';
import { FieldType, FormlyMatFormFieldModule } from '@ngx-formly/material/form-field';
import * as i1 from '@angular/common';
import { CommonModule } from '@angular/common';
import * as i2 from '@angular/forms';
import { ReactiveFormsModule } from '@angular/forms';
import * as i4 from '@angular/material/core';
import { MatPseudoCheckboxModule } from '@angular/material/core';
import * as i6 from '@ngx-formly/core/select';
import { FormlySelectModule } from '@ngx-formly/core/select';

class FormlyFieldSelect extends FieldType {
    constructor() {
        super(...arguments);
        this.defaultOptions = {
            props: {
                compareWith(o1, o2) {
                    return o1 === o2;
                },
            },
        };
    }
    set select(select) {
        _observe(select, ['_parentFormField', '_textField'], ({ currentValue }) => {
            if (currentValue) {
                select._preferredOverlayOrigin = select._parentFormField.getConnectedOverlayOrigin();
            }
        });
    }
    getSelectAllState(options) {
        if (this.empty || this.value.length === 0) {
            return null;
        }
        return this.value.length !== this.getSelectAllValue(options).length ? 'indeterminate' : 'checked';
    }
    toggleSelectAll(options) {
        const selectAllValue = this.getSelectAllValue(options);
        this.formControl.markAsDirty();
        this.formControl.setValue(!this.value || this.value.length !== selectAllValue.length ? selectAllValue : []);
    }
    change($event) {
        this.props.change?.(this.field, $event);
    }
    _getAriaLabelledby() {
        if (this.props.attributes?.['aria-labelledby']) {
            return this.props.attributes['aria-labelledby'];
        }
        return this.formField?._labelId;
    }
    _getAriaLabel() {
        return this.props.attributes?.['aria-label'];
    }
    getSelectAllValue(options) {
        if (!this.selectAllValue || options !== this.selectAllValue.options) {
            const flatOptions = [];
            options.forEach((o) => (o.group ? flatOptions.push(...o.group) : flatOptions.push(o)));
            this.selectAllValue = {
                options,
                value: flatOptions.filter((o) => !o.disabled).map((o) => o.value),
            };
        }
        return this.selectAllValue.value;
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyFieldSelect, deps: null, target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "17.0.0", version: "18.2.13", type: FormlyFieldSelect, selector: "formly-field-mat-select", viewQueries: [{ propertyName: "select", first: true, predicate: MatSelect, descendants: true, static: true }], usesInheritance: true, ngImport: i0, template: `
    <ng-template #selectAll let-selectOptions="selectOptions">
      <mat-option (click)="toggleSelectAll(selectOptions)">
        <mat-pseudo-checkbox class="mat-option-pseudo-checkbox" [state]="getSelectAllState(selectOptions)">
        </mat-pseudo-checkbox>
        {{ props.selectAllOption }}
      </mat-option>
    </ng-template>

    <mat-select
      [id]="id"
      [formControl]="formControl"
      [formlyAttributes]="field"
      [placeholder]="props.placeholder"
      [tabIndex]="props.tabindex"
      [required]="required"
      [compareWith]="props.compareWith"
      [multiple]="props.multiple"
      (selectionChange)="change($event)"
      [errorStateMatcher]="errorStateMatcher"
      [aria-label]="_getAriaLabel()"
      [aria-labelledby]="_getAriaLabelledby()"
      [disableOptionCentering]="props.disableOptionCentering"
      [typeaheadDebounceInterval]="props.typeaheadDebounceInterval"
      [panelClass]="props.panelClass"
    >
      @if (props.options | formlySelectOptions: field | async; as selectOptions) {
        @if (props.multiple && props.selectAllOption) {
          <ng-container [ngTemplateOutlet]="selectAll" [ngTemplateOutletContext]="{ selectOptions: selectOptions }">
          </ng-container>
        }
        @for (item of selectOptions; track $index) {
          @if (item.group) {
            <mat-optgroup [label]="item.label">
              @for (child of item.group; track $index) {
                <mat-option [value]="child.value" [disabled]="child.disabled">
                  {{ child.label }}
                </mat-option>
              }
            </mat-optgroup>
          } @else {
            <mat-option [value]="item.value" [disabled]="item.disabled">{{ item.label }}</mat-option>
          }
        }
      }
    </mat-select>
  `, isInline: true, dependencies: [{ kind: "directive", type: i1.NgTemplateOutlet, selector: "[ngTemplateOutlet]", inputs: ["ngTemplateOutletContext", "ngTemplateOutlet", "ngTemplateOutletInjector"] }, { kind: "directive", type: i2.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i2.RequiredValidator, selector: ":not([type=checkbox])[required][formControlName],:not([type=checkbox])[required][formControl],:not([type=checkbox])[required][ngModel]", inputs: ["required"] }, { kind: "directive", type: i2.FormControlDirective, selector: "[formControl]", inputs: ["formControl", "disabled", "ngModel"], outputs: ["ngModelChange"], exportAs: ["ngForm"] }, { kind: "component", type: i3.MatSelect, selector: "mat-select", inputs: ["aria-describedby", "panelClass", "disabled", "disableRipple", "tabIndex", "hideSingleSelectionIndicator", "placeholder", "required", "multiple", "disableOptionCentering", "compareWith", "value", "aria-label", "aria-labelledby", "errorStateMatcher", "typeaheadDebounceInterval", "sortComparator", "id", "panelWidth"], outputs: ["openedChange", "opened", "closed", "selectionChange", "valueChange"], exportAs: ["matSelect"] }, { kind: "component", type: i4.MatOption, selector: "mat-option", inputs: ["value", "id", "disabled"], outputs: ["onSelectionChange"], exportAs: ["matOption"] }, { kind: "component", type: i4.MatOptgroup, selector: "mat-optgroup", inputs: ["label", "disabled"], exportAs: ["matOptgroup"] }, { kind: "component", type: i4.MatPseudoCheckbox, selector: "mat-pseudo-checkbox", inputs: ["state", "disabled", "appearance"] }, { kind: "directive", type: i5.LegacyFormlyAttributes, selector: "[formlyAttributes]" }, { kind: "pipe", type: i1.AsyncPipe, name: "async" }, { kind: "pipe", type: i6.LegacyFormlySelectOptionsPipe, name: "formlySelectOptions" }], changeDetection: i0.ChangeDetectionStrategy.OnPush }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyFieldSelect, decorators: [{
            type: Component,
            args: [{
                    selector: 'formly-field-mat-select',
                    template: `
    <ng-template #selectAll let-selectOptions="selectOptions">
      <mat-option (click)="toggleSelectAll(selectOptions)">
        <mat-pseudo-checkbox class="mat-option-pseudo-checkbox" [state]="getSelectAllState(selectOptions)">
        </mat-pseudo-checkbox>
        {{ props.selectAllOption }}
      </mat-option>
    </ng-template>

    <mat-select
      [id]="id"
      [formControl]="formControl"
      [formlyAttributes]="field"
      [placeholder]="props.placeholder"
      [tabIndex]="props.tabindex"
      [required]="required"
      [compareWith]="props.compareWith"
      [multiple]="props.multiple"
      (selectionChange)="change($event)"
      [errorStateMatcher]="errorStateMatcher"
      [aria-label]="_getAriaLabel()"
      [aria-labelledby]="_getAriaLabelledby()"
      [disableOptionCentering]="props.disableOptionCentering"
      [typeaheadDebounceInterval]="props.typeaheadDebounceInterval"
      [panelClass]="props.panelClass"
    >
      @if (props.options | formlySelectOptions: field | async; as selectOptions) {
        @if (props.multiple && props.selectAllOption) {
          <ng-container [ngTemplateOutlet]="selectAll" [ngTemplateOutletContext]="{ selectOptions: selectOptions }">
          </ng-container>
        }
        @for (item of selectOptions; track $index) {
          @if (item.group) {
            <mat-optgroup [label]="item.label">
              @for (child of item.group; track $index) {
                <mat-option [value]="child.value" [disabled]="child.disabled">
                  {{ child.label }}
                </mat-option>
              }
            </mat-optgroup>
          } @else {
            <mat-option [value]="item.value" [disabled]="item.disabled">{{ item.label }}</mat-option>
          }
        }
      }
    </mat-select>
  `,
                    changeDetection: ChangeDetectionStrategy.OnPush,
                }]
        }], propDecorators: { select: [{
                type: ViewChild,
                args: [MatSelect, { static: true }]
            }] } });

function withFormlyFieldSelect() {
    return {
        types: [
            {
                name: 'select',
                component: FormlyFieldSelect,
                wrappers: ['form-field'],
            },
            { name: 'enum', extends: 'select' },
        ],
    };
}

class FormlyMatSelectModule {
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyMatSelectModule, deps: [], target: i0.ɵɵFactoryTarget.NgModule }); }
    static { this.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "14.0.0", version: "18.2.13", ngImport: i0, type: FormlyMatSelectModule, declarations: [FormlyFieldSelect], imports: [CommonModule,
            ReactiveFormsModule,
            MatSelectModule,
            MatPseudoCheckboxModule,
            FormlyMatFormFieldModule,
            FormlySelectModule, i5.FormlyModule] }); }
    static { this.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyMatSelectModule, imports: [CommonModule,
            ReactiveFormsModule,
            MatSelectModule,
            MatPseudoCheckboxModule,
            FormlyMatFormFieldModule,
            FormlySelectModule,
            FormlyModule.forChild(withFormlyFieldSelect())] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyMatSelectModule, decorators: [{
            type: NgModule,
            args: [{
                    declarations: [FormlyFieldSelect],
                    imports: [
                        CommonModule,
                        ReactiveFormsModule,
                        MatSelectModule,
                        MatPseudoCheckboxModule,
                        FormlyMatFormFieldModule,
                        FormlySelectModule,
                        FormlyModule.forChild(withFormlyFieldSelect()),
                    ],
                }]
        }] });

/**
 * Generated bundle index. Do not edit.
 */

export { FormlyFieldSelect, FormlyMatSelectModule, withFormlyFieldSelect };
//# sourceMappingURL=ngx-formly-material-select.mjs.map
