import * as i0 from '@angular/core';
import { ViewChild, ViewEncapsulation, Component, NO_ERRORS_SCHEMA, NgModule, Type, ViewChildren, Directive } from '@angular/core';
import * as i4 from '@ngx-formly/core';
import { FieldWrapper, ɵdefineHiddenProp as _defineHiddenProp, FormlyModule, FieldType as FieldType$1, ɵobserve as _observe } from '@ngx-formly/core';
import * as i3 from '@angular/material/form-field';
import { MatFormField, MatFormFieldModule, MatFormFieldControl } from '@angular/material/form-field';
import * as i1 from '@angular/cdk/a11y';
import * as i2 from '@angular/common';
import { CommonModule } from '@angular/common';
import { ReactiveFormsModule } from '@angular/forms';
import { Subject } from 'rxjs';

class FormlyWrapperFormField extends FieldWrapper {
    constructor(renderer, elementRef, focusMonitor) {
        super();
        this.renderer = renderer;
        this.elementRef = elementRef;
        this.focusMonitor = focusMonitor;
    }
    ngOnInit() {
        _defineHiddenProp(this.field, '_formField', this.formField);
        this.focusMonitor.monitor(this.elementRef, true).subscribe((origin) => {
            if (!origin && this.field.focus) {
                this.field.focus = false;
            }
        });
    }
    ngAfterViewInit() {
        // temporary fix for https://github.com/angular/material2/issues/7891
        if (this.formField.appearance !== 'outline' && this.props.hideFieldUnderline === true) {
            const underlineElement = this.formField._elementRef.nativeElement.querySelector('.mat-form-field-underline');
            underlineElement && this.renderer.removeChild(underlineElement.parentNode, underlineElement);
        }
    }
    ngOnDestroy() {
        delete this.field._formField;
        this.focusMonitor.stopMonitoring(this.elementRef);
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyWrapperFormField, deps: [{ token: i0.Renderer2 }, { token: i0.ElementRef }, { token: i1.FocusMonitor }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "17.0.0", version: "18.2.13", type: FormlyWrapperFormField, selector: "formly-wrapper-mat-form-field", viewQueries: [{ propertyName: "formField", first: true, predicate: MatFormField, descendants: true, static: true }], usesInheritance: true, ngImport: i0, template: `
    <!-- fix https://github.com/angular/material2/pull/7083 by setting width to 100% -->
    <mat-form-field
      [hideRequiredMarker]="true"
      [floatLabel]="props.floatLabel"
      [appearance]="props.appearance"
      [subscriptSizing]="props.subscriptSizing"
      [color]="props.color ?? 'primary'"
    >
      <ng-container #fieldComponent></ng-container>
      @if (props.label && props.hideLabel !== true) {
        <mat-label>
          {{ props.label }}
          @if (props.required && props.hideRequiredMarker !== true) {
            <span aria-hidden="true" class="mat-form-field-required-marker mat-mdc-form-field-required-marker">*</span>
          }
        </mat-label>
      }

      @if (props.textPrefix) {
        <ng-container
          matTextPrefix
          [ngTemplateOutlet]="props.textPrefix"
          [ngTemplateOutletContext]="{ field: field }"
        ></ng-container>
      }

      @if (props.prefix) {
        <ng-container
          matPrefix
          [ngTemplateOutlet]="props.prefix"
          [ngTemplateOutletContext]="{ field: field }"
        ></ng-container>
      }

      @if (props.textSuffix) {
        <ng-container
          matTextSuffix
          [ngTemplateOutlet]="props.textSuffix"
          [ngTemplateOutletContext]="{ field: field }"
        ></ng-container>
      }

      @if (props.suffix) {
        <ng-container
          matSuffix
          [ngTemplateOutlet]="props.suffix"
          [ngTemplateOutletContext]="{ field: field }"
        ></ng-container>
      }

      <mat-error>
        <formly-validation-message [field]="field"></formly-validation-message>
      </mat-error>

      @if (props.description || props.hintStart; as hint) {
        <mat-hint>
          <ng-container [ngTemplateOutlet]="stringOrTemplate" [ngTemplateOutletContext]="{ content: hint }">
          </ng-container>
        </mat-hint>
      }

      @if (props.hintEnd; as hintEnd) {
        <mat-hint align="end">
          <ng-container [ngTemplateOutlet]="stringOrTemplate" [ngTemplateOutletContext]="{ content: hintEnd }">
          </ng-container>
        </mat-hint>
      }
    </mat-form-field>

    <ng-template #stringOrTemplate let-content="content">
      @if (!content.createEmbeddedView) {
        {{ content }}
      } @else {
        <ng-container [ngTemplateOutlet]="content" [ngTemplateOutletContext]="{ field: field }"></ng-container>
      }
    </ng-template>
  `, isInline: true, styles: ["formly-wrapper-mat-form-field .mat-mdc-form-field,formly-wrapper-mat-form-field .mat-form-field{width:100%}\n"], dependencies: [{ kind: "directive", type: i2.NgTemplateOutlet, selector: "[ngTemplateOutlet]", inputs: ["ngTemplateOutletContext", "ngTemplateOutlet", "ngTemplateOutletInjector"] }, { kind: "component", type: i3.MatFormField, selector: "mat-form-field", inputs: ["hideRequiredMarker", "color", "floatLabel", "appearance", "subscriptSizing", "hintLabel"], exportAs: ["matFormField"] }, { kind: "directive", type: i3.MatLabel, selector: "mat-label" }, { kind: "directive", type: i3.MatHint, selector: "mat-hint", inputs: ["align", "id"] }, { kind: "directive", type: i3.MatError, selector: "mat-error, [matError]", inputs: ["id"] }, { kind: "directive", type: i3.MatPrefix, selector: "[matPrefix], [matIconPrefix], [matTextPrefix]", inputs: ["matTextPrefix"] }, { kind: "directive", type: i3.MatSuffix, selector: "[matSuffix], [matIconSuffix], [matTextSuffix]", inputs: ["matTextSuffix"] }, { kind: "component", type: i4.LegacyFormlyValidationMessage, selector: "formly-validation-message" }], encapsulation: i0.ViewEncapsulation.None }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyWrapperFormField, decorators: [{
            type: Component,
            args: [{ selector: 'formly-wrapper-mat-form-field', template: `
    <!-- fix https://github.com/angular/material2/pull/7083 by setting width to 100% -->
    <mat-form-field
      [hideRequiredMarker]="true"
      [floatLabel]="props.floatLabel"
      [appearance]="props.appearance"
      [subscriptSizing]="props.subscriptSizing"
      [color]="props.color ?? 'primary'"
    >
      <ng-container #fieldComponent></ng-container>
      @if (props.label && props.hideLabel !== true) {
        <mat-label>
          {{ props.label }}
          @if (props.required && props.hideRequiredMarker !== true) {
            <span aria-hidden="true" class="mat-form-field-required-marker mat-mdc-form-field-required-marker">*</span>
          }
        </mat-label>
      }

      @if (props.textPrefix) {
        <ng-container
          matTextPrefix
          [ngTemplateOutlet]="props.textPrefix"
          [ngTemplateOutletContext]="{ field: field }"
        ></ng-container>
      }

      @if (props.prefix) {
        <ng-container
          matPrefix
          [ngTemplateOutlet]="props.prefix"
          [ngTemplateOutletContext]="{ field: field }"
        ></ng-container>
      }

      @if (props.textSuffix) {
        <ng-container
          matTextSuffix
          [ngTemplateOutlet]="props.textSuffix"
          [ngTemplateOutletContext]="{ field: field }"
        ></ng-container>
      }

      @if (props.suffix) {
        <ng-container
          matSuffix
          [ngTemplateOutlet]="props.suffix"
          [ngTemplateOutletContext]="{ field: field }"
        ></ng-container>
      }

      <mat-error>
        <formly-validation-message [field]="field"></formly-validation-message>
      </mat-error>

      @if (props.description || props.hintStart; as hint) {
        <mat-hint>
          <ng-container [ngTemplateOutlet]="stringOrTemplate" [ngTemplateOutletContext]="{ content: hint }">
          </ng-container>
        </mat-hint>
      }

      @if (props.hintEnd; as hintEnd) {
        <mat-hint align="end">
          <ng-container [ngTemplateOutlet]="stringOrTemplate" [ngTemplateOutletContext]="{ content: hintEnd }">
          </ng-container>
        </mat-hint>
      }
    </mat-form-field>

    <ng-template #stringOrTemplate let-content="content">
      @if (!content.createEmbeddedView) {
        {{ content }}
      } @else {
        <ng-container [ngTemplateOutlet]="content" [ngTemplateOutletContext]="{ field: field }"></ng-container>
      }
    </ng-template>
  `, encapsulation: ViewEncapsulation.None, styles: ["formly-wrapper-mat-form-field .mat-mdc-form-field,formly-wrapper-mat-form-field .mat-form-field{width:100%}\n"] }]
        }], ctorParameters: () => [{ type: i0.Renderer2 }, { type: i0.ElementRef }, { type: i1.FocusMonitor }], propDecorators: { formField: [{
                type: ViewChild,
                args: [MatFormField, { static: true }]
            }] } });

function withFormlyFormField() {
    return {
        wrappers: [
            {
                name: 'form-field',
                component: FormlyWrapperFormField,
            },
        ],
    };
}

class FormlyMatFormFieldModule {
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyMatFormFieldModule, deps: [], target: i0.ɵɵFactoryTarget.NgModule }); }
    static { this.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "14.0.0", version: "18.2.13", ngImport: i0, type: FormlyMatFormFieldModule, declarations: [FormlyWrapperFormField], imports: [CommonModule, ReactiveFormsModule, MatFormFieldModule, i4.FormlyModule] }); }
    static { this.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyMatFormFieldModule, imports: [CommonModule, ReactiveFormsModule, MatFormFieldModule, FormlyModule.forChild(withFormlyFormField())] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyMatFormFieldModule, decorators: [{
            type: NgModule,
            args: [{
                    declarations: [FormlyWrapperFormField],
                    imports: [CommonModule, ReactiveFormsModule, MatFormFieldModule, FormlyModule.forChild(withFormlyFormField())],
                    schemas: [NO_ERRORS_SCHEMA],
                }]
        }] });

class FieldType extends FieldType$1 {
    constructor() {
        super(...arguments);
        this.errorStateMatcher = { isErrorState: () => this.field && this.showError };
        this.stateChanges = new Subject();
        this._errorState = false;
        this._focused = false;
    }
    set matPrefix(prefix) {
        if (prefix) {
            this.props.prefix = prefix;
        }
    }
    set matTextPrefix(textPrefix) {
        if (textPrefix) {
            this.props.textPrefix = textPrefix;
        }
    }
    set matSuffix(suffix) {
        if (suffix) {
            this.props.suffix = suffix;
        }
    }
    set matTextSuffix(textSuffix) {
        if (textSuffix) {
            this.props.textSuffix = textSuffix;
        }
    }
    set _controls(controls) {
        this.attachControl(controls.length === 1 ? controls.first : this);
    }
    ngOnDestroy() {
        delete this.formField?._control;
        this.stateChanges.complete();
    }
    setDescribedByIds(_ids) { }
    onContainerClick(_event) {
        this.field.focus = true;
        this.stateChanges.next();
    }
    get errorState() {
        const showError = this.options.showError(this);
        if (showError !== this._errorState) {
            this._errorState = showError;
            this.stateChanges.next();
        }
        return showError;
    }
    get controlType() {
        if (this.props.type) {
            return this.props.type;
        }
        const type = this.field.type;
        return type instanceof Type ? type.prototype.constructor.name : type;
    }
    get focused() {
        const focused = !!this.field.focus && !this.disabled;
        if (focused !== this._focused) {
            this._focused = focused;
            this.stateChanges.next();
        }
        return focused;
    }
    get disabled() {
        return !!this.props.disabled;
    }
    get required() {
        return !!this.props.required;
    }
    get placeholder() {
        return this.props.placeholder || '';
    }
    get shouldPlaceholderFloat() {
        return this.shouldLabelFloat;
    }
    get value() {
        return this.formControl?.value;
    }
    set value(value) {
        this.formControl?.patchValue(value);
    }
    get ngControl() {
        return this.formControl;
    }
    get empty() {
        return this.value == null || this.value === '';
    }
    get shouldLabelFloat() {
        return this.focused || !this.empty;
    }
    get formField() {
        return this.field?.['_formField'];
    }
    attachControl(control) {
        if (this.formField && control !== this.formField._control) {
            this.formField._control = control;
            // temporary fix for https://github.com/angular/material2/issues/6728
            const ngControl = control?.ngControl;
            if (ngControl?.valueAccessor?.hasOwnProperty('_formField')) {
                ngControl.valueAccessor['_formField'] = this.formField;
            }
            if (ngControl?.valueAccessor?.hasOwnProperty('_parentFormField')) {
                ngControl.valueAccessor['_parentFormField'] = this.formField;
            }
            ['prefix', 'suffix', 'textPrefix', 'textSuffix'].forEach((type) => _observe(this.field, ['props', type], ({ currentValue }) => currentValue &&
                Promise.resolve().then(() => {
                    this.options.detectChanges(this.field);
                })));
            // https://github.com/angular/components/issues/16209
            const setDescribedByIds = control.setDescribedByIds.bind(control);
            control.setDescribedByIds = (ids) => {
                setTimeout(() => setDescribedByIds(ids));
            };
        }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FieldType, deps: null, target: i0.ɵɵFactoryTarget.Directive }); }
    static { this.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "18.2.13", type: FieldType, viewQueries: [{ propertyName: "matPrefix", first: true, predicate: ["matPrefix"], descendants: true }, { propertyName: "matTextPrefix", first: true, predicate: ["matTextPrefix"], descendants: true }, { propertyName: "matSuffix", first: true, predicate: ["matSuffix"], descendants: true }, { propertyName: "matTextSuffix", first: true, predicate: ["matTextSuffix"], descendants: true }, { propertyName: "_controls", predicate: MatFormFieldControl, descendants: true }], usesInheritance: true, ngImport: i0 }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FieldType, decorators: [{
            type: Directive
        }], propDecorators: { matPrefix: [{
                type: ViewChild,
                args: ['matPrefix']
            }], matTextPrefix: [{
                type: ViewChild,
                args: ['matTextPrefix']
            }], matSuffix: [{
                type: ViewChild,
                args: ['matSuffix']
            }], matTextSuffix: [{
                type: ViewChild,
                args: ['matTextSuffix']
            }], _controls: [{
                type: ViewChildren,
                args: [MatFormFieldControl]
            }] } });

/**
 * Generated bundle index. Do not edit.
 */

export { FieldType, FormlyMatFormFieldModule, withFormlyFormField };
//# sourceMappingURL=ngx-formly-material-form-field.mjs.map
