import * as i0 from '@angular/core';
import { ViewChild, ChangeDetectionStrategy, Component, NgModule } from '@angular/core';
import { FieldType, FormlyMatFormFieldModule } from '@ngx-formly/material/form-field';
import * as i3 from '@angular/material/checkbox';
import { MatCheckbox, MatCheckboxModule } from '@angular/material/checkbox';
import * as i1 from '@angular/cdk/a11y';
import * as i2 from '@angular/forms';
import { ReactiveFormsModule } from '@angular/forms';
import * as i4 from '@ngx-formly/core';
import { FormlyModule } from '@ngx-formly/core';
import { CommonModule } from '@angular/common';

class FormlyFieldCheckbox extends FieldType {
    constructor(renderer, focusMonitor) {
        super();
        this.renderer = renderer;
        this.focusMonitor = focusMonitor;
        this.defaultOptions = {
            props: {
                hideFieldUnderline: true,
                indeterminate: true,
                floatLabel: 'always',
                hideLabel: true,
                color: 'accent', // workaround for https://github.com/angular/components/issues/18465
            },
        };
    }
    onContainerClick(event) {
        this.checkbox.focus();
        super.onContainerClick(event);
    }
    ngAfterViewInit() {
        if (this.checkbox) {
            this.focusMonitor.monitor(this.checkbox._inputElement, true).subscribe((focusOrigin) => {
                this.field.focus = !!focusOrigin;
                this.stateChanges.next();
                if (focusOrigin) {
                    this.props.focus && this.props.focus(this.field);
                }
                else {
                    this.props.blur && this.props.blur(this.field);
                }
            });
        }
    }
    ngAfterViewChecked() {
        if (this.required !== this._required && this.checkbox && this.checkbox._inputElement) {
            this._required = this.required;
            const inputElement = this.checkbox._inputElement.nativeElement;
            if (this.required) {
                this.renderer.setAttribute(inputElement, 'required', 'required');
            }
            else {
                this.renderer.removeAttribute(inputElement, 'required');
            }
        }
    }
    ngOnDestroy() {
        super.ngOnDestroy();
        if (this.checkbox) {
            this.focusMonitor.stopMonitoring(this.checkbox._inputElement);
        }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyFieldCheckbox, deps: [{ token: i0.Renderer2 }, { token: i1.FocusMonitor }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "17.0.0", version: "18.2.13", type: FormlyFieldCheckbox, selector: "formly-field-mat-checkbox", viewQueries: [{ propertyName: "checkbox", first: true, predicate: MatCheckbox, descendants: true, static: true }], usesInheritance: true, ngImport: i0, template: `
    <mat-checkbox
      [formControl]="formControl"
      [id]="id"
      [name]="field.name"
      [formlyAttributes]="field"
      [tabIndex]="props.tabindex"
      [indeterminate]="props.indeterminate && formControl.value == null"
      [color]="props.color"
      [labelPosition]="props.labelPosition"
    >
      {{ props.label }}
      @if (props.required && props.hideRequiredMarker !== true) {
        <span aria-hidden="true" class="mat-form-field-required-marker mat-mdc-form-field-required-marker">*</span>
      }
    </mat-checkbox>
  `, isInline: true, dependencies: [{ kind: "directive", type: i2.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i2.FormControlDirective, selector: "[formControl]", inputs: ["formControl", "disabled", "ngModel"], outputs: ["ngModelChange"], exportAs: ["ngForm"] }, { kind: "component", type: i3.MatCheckbox, selector: "mat-checkbox", inputs: ["aria-label", "aria-labelledby", "aria-describedby", "id", "required", "labelPosition", "name", "value", "disableRipple", "tabIndex", "color", "disabledInteractive", "checked", "disabled", "indeterminate"], outputs: ["change", "indeterminateChange"], exportAs: ["matCheckbox"] }, { kind: "directive", type: i4.LegacyFormlyAttributes, selector: "[formlyAttributes]" }], changeDetection: i0.ChangeDetectionStrategy.OnPush }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyFieldCheckbox, decorators: [{
            type: Component,
            args: [{
                    selector: 'formly-field-mat-checkbox',
                    template: `
    <mat-checkbox
      [formControl]="formControl"
      [id]="id"
      [name]="field.name"
      [formlyAttributes]="field"
      [tabIndex]="props.tabindex"
      [indeterminate]="props.indeterminate && formControl.value == null"
      [color]="props.color"
      [labelPosition]="props.labelPosition"
    >
      {{ props.label }}
      @if (props.required && props.hideRequiredMarker !== true) {
        <span aria-hidden="true" class="mat-form-field-required-marker mat-mdc-form-field-required-marker">*</span>
      }
    </mat-checkbox>
  `,
                    changeDetection: ChangeDetectionStrategy.OnPush,
                }]
        }], ctorParameters: () => [{ type: i0.Renderer2 }, { type: i1.FocusMonitor }], propDecorators: { checkbox: [{
                type: ViewChild,
                args: [MatCheckbox, { static: true }]
            }] } });

function withFormlyFieldCheckbox() {
    return {
        types: [
            {
                name: 'checkbox',
                component: FormlyFieldCheckbox,
                wrappers: ['form-field'],
            },
            {
                name: 'boolean',
                extends: 'checkbox',
            },
        ],
    };
}

class FormlyMatCheckboxModule {
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyMatCheckboxModule, deps: [], target: i0.ɵɵFactoryTarget.NgModule }); }
    static { this.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "14.0.0", version: "18.2.13", ngImport: i0, type: FormlyMatCheckboxModule, declarations: [FormlyFieldCheckbox], imports: [CommonModule,
            ReactiveFormsModule,
            MatCheckboxModule,
            FormlyMatFormFieldModule, i4.FormlyModule] }); }
    static { this.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyMatCheckboxModule, imports: [CommonModule,
            ReactiveFormsModule,
            MatCheckboxModule,
            FormlyMatFormFieldModule,
            FormlyModule.forChild(withFormlyFieldCheckbox())] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyMatCheckboxModule, decorators: [{
            type: NgModule,
            args: [{
                    declarations: [FormlyFieldCheckbox],
                    imports: [
                        CommonModule,
                        ReactiveFormsModule,
                        MatCheckboxModule,
                        FormlyMatFormFieldModule,
                        FormlyModule.forChild(withFormlyFieldCheckbox()),
                    ],
                }]
        }] });

/**
 * Generated bundle index. Do not edit.
 */

export { FormlyFieldCheckbox, FormlyMatCheckboxModule, withFormlyFieldCheckbox };
//# sourceMappingURL=ngx-formly-material-checkbox.mjs.map
