import { Component, ChangeDetectionStrategy } from '@angular/core';
import { FieldType } from '@ngx-formly/material/form-field';
import * as i0 from "@angular/core";
import * as i1 from "@angular/forms";
import * as i2 from "@angular/material/slider";
import * as i3 from "@ngx-formly/core";
export class FormlyFieldSlider extends FieldType {
    constructor() {
        super(...arguments);
        this.defaultOptions = {
            props: {
                hideFieldUnderline: true,
                floatLabel: 'always',
                displayWith: (value) => `${value}`,
            },
        };
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyFieldSlider, deps: null, target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.13", type: FormlyFieldSlider, selector: "formly-field-mat-slider", usesInheritance: true, ngImport: i0, template: `
    <mat-slider
      [id]="id"
      [style.width]="'100%'"
      [formlyAttributes]="field"
      [tabIndex]="props.tabindex"
      [color]="props.color"
      [displayWith]="props.displayWith"
      [max]="props.max"
      [min]="props.min"
      [step]="props.step"
      [discrete]="props.discrete"
      [showTickMarks]="props.showTickMarks"
      [step]="props.step"
      (input)="props.input && props.input(field, $event)"
      (change)="props.change && props.change(field, $event)"
    >
      <input matSliderThumb [formControl]="formControl" [formlyAttributes]="field" />
    </mat-slider>
  `, isInline: true, dependencies: [{ kind: "directive", type: i1.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i1.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i1.FormControlDirective, selector: "[formControl]", inputs: ["formControl", "disabled", "ngModel"], outputs: ["ngModelChange"], exportAs: ["ngForm"] }, { kind: "component", type: i2.MatSlider, selector: "mat-slider", inputs: ["disabled", "discrete", "showTickMarks", "min", "color", "disableRipple", "max", "step", "displayWith"], exportAs: ["matSlider"] }, { kind: "directive", type: i2.MatSliderThumb, selector: "input[matSliderThumb]", inputs: ["value"], outputs: ["valueChange", "dragStart", "dragEnd"], exportAs: ["matSliderThumb"] }, { kind: "directive", type: i3.LegacyFormlyAttributes, selector: "[formlyAttributes]" }], changeDetection: i0.ChangeDetectionStrategy.OnPush }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyFieldSlider, decorators: [{
            type: Component,
            args: [{
                    selector: 'formly-field-mat-slider',
                    template: `
    <mat-slider
      [id]="id"
      [style.width]="'100%'"
      [formlyAttributes]="field"
      [tabIndex]="props.tabindex"
      [color]="props.color"
      [displayWith]="props.displayWith"
      [max]="props.max"
      [min]="props.min"
      [step]="props.step"
      [discrete]="props.discrete"
      [showTickMarks]="props.showTickMarks"
      [step]="props.step"
      (input)="props.input && props.input(field, $event)"
      (change)="props.change && props.change(field, $event)"
    >
      <input matSliderThumb [formControl]="formControl" [formlyAttributes]="field" />
    </mat-slider>
  `,
                    changeDetection: ChangeDetectionStrategy.OnPush,
                }]
        }] });
//# sourceMappingURL=data:application/json;base64,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