import { Component, ChangeDetectionStrategy, ViewChild } from '@angular/core';
import { MatSelect } from '@angular/material/select';
import { ɵobserve as observe } from '@ngx-formly/core';
import { FieldType } from '@ngx-formly/material/form-field';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "@angular/forms";
import * as i3 from "@angular/material/select";
import * as i4 from "@angular/material/core";
import * as i5 from "@ngx-formly/core";
import * as i6 from "@ngx-formly/core/select";
export class FormlyFieldSelect extends FieldType {
    constructor() {
        super(...arguments);
        this.defaultOptions = {
            props: {
                compareWith(o1, o2) {
                    return o1 === o2;
                },
            },
        };
    }
    set select(select) {
        observe(select, ['_parentFormField', '_textField'], ({ currentValue }) => {
            if (currentValue) {
                select._preferredOverlayOrigin = select._parentFormField.getConnectedOverlayOrigin();
            }
        });
    }
    getSelectAllState(options) {
        if (this.empty || this.value.length === 0) {
            return null;
        }
        return this.value.length !== this.getSelectAllValue(options).length ? 'indeterminate' : 'checked';
    }
    toggleSelectAll(options) {
        const selectAllValue = this.getSelectAllValue(options);
        this.formControl.markAsDirty();
        this.formControl.setValue(!this.value || this.value.length !== selectAllValue.length ? selectAllValue : []);
    }
    change($event) {
        this.props.change?.(this.field, $event);
    }
    _getAriaLabelledby() {
        if (this.props.attributes?.['aria-labelledby']) {
            return this.props.attributes['aria-labelledby'];
        }
        return this.formField?._labelId;
    }
    _getAriaLabel() {
        return this.props.attributes?.['aria-label'];
    }
    getSelectAllValue(options) {
        if (!this.selectAllValue || options !== this.selectAllValue.options) {
            const flatOptions = [];
            options.forEach((o) => (o.group ? flatOptions.push(...o.group) : flatOptions.push(o)));
            this.selectAllValue = {
                options,
                value: flatOptions.filter((o) => !o.disabled).map((o) => o.value),
            };
        }
        return this.selectAllValue.value;
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyFieldSelect, deps: null, target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "17.0.0", version: "18.2.13", type: FormlyFieldSelect, selector: "formly-field-mat-select", viewQueries: [{ propertyName: "select", first: true, predicate: MatSelect, descendants: true, static: true }], usesInheritance: true, ngImport: i0, template: `
    <ng-template #selectAll let-selectOptions="selectOptions">
      <mat-option (click)="toggleSelectAll(selectOptions)">
        <mat-pseudo-checkbox class="mat-option-pseudo-checkbox" [state]="getSelectAllState(selectOptions)">
        </mat-pseudo-checkbox>
        {{ props.selectAllOption }}
      </mat-option>
    </ng-template>

    <mat-select
      [id]="id"
      [formControl]="formControl"
      [formlyAttributes]="field"
      [placeholder]="props.placeholder"
      [tabIndex]="props.tabindex"
      [required]="required"
      [compareWith]="props.compareWith"
      [multiple]="props.multiple"
      (selectionChange)="change($event)"
      [errorStateMatcher]="errorStateMatcher"
      [aria-label]="_getAriaLabel()"
      [aria-labelledby]="_getAriaLabelledby()"
      [disableOptionCentering]="props.disableOptionCentering"
      [typeaheadDebounceInterval]="props.typeaheadDebounceInterval"
      [panelClass]="props.panelClass"
    >
      @if (props.options | formlySelectOptions: field | async; as selectOptions) {
        @if (props.multiple && props.selectAllOption) {
          <ng-container [ngTemplateOutlet]="selectAll" [ngTemplateOutletContext]="{ selectOptions: selectOptions }">
          </ng-container>
        }
        @for (item of selectOptions; track $index) {
          @if (item.group) {
            <mat-optgroup [label]="item.label">
              @for (child of item.group; track $index) {
                <mat-option [value]="child.value" [disabled]="child.disabled">
                  {{ child.label }}
                </mat-option>
              }
            </mat-optgroup>
          } @else {
            <mat-option [value]="item.value" [disabled]="item.disabled">{{ item.label }}</mat-option>
          }
        }
      }
    </mat-select>
  `, isInline: true, dependencies: [{ kind: "directive", type: i1.NgTemplateOutlet, selector: "[ngTemplateOutlet]", inputs: ["ngTemplateOutletContext", "ngTemplateOutlet", "ngTemplateOutletInjector"] }, { kind: "directive", type: i2.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i2.RequiredValidator, selector: ":not([type=checkbox])[required][formControlName],:not([type=checkbox])[required][formControl],:not([type=checkbox])[required][ngModel]", inputs: ["required"] }, { kind: "directive", type: i2.FormControlDirective, selector: "[formControl]", inputs: ["formControl", "disabled", "ngModel"], outputs: ["ngModelChange"], exportAs: ["ngForm"] }, { kind: "component", type: i3.MatSelect, selector: "mat-select", inputs: ["aria-describedby", "panelClass", "disabled", "disableRipple", "tabIndex", "hideSingleSelectionIndicator", "placeholder", "required", "multiple", "disableOptionCentering", "compareWith", "value", "aria-label", "aria-labelledby", "errorStateMatcher", "typeaheadDebounceInterval", "sortComparator", "id", "panelWidth"], outputs: ["openedChange", "opened", "closed", "selectionChange", "valueChange"], exportAs: ["matSelect"] }, { kind: "component", type: i4.MatOption, selector: "mat-option", inputs: ["value", "id", "disabled"], outputs: ["onSelectionChange"], exportAs: ["matOption"] }, { kind: "component", type: i4.MatOptgroup, selector: "mat-optgroup", inputs: ["label", "disabled"], exportAs: ["matOptgroup"] }, { kind: "component", type: i4.MatPseudoCheckbox, selector: "mat-pseudo-checkbox", inputs: ["state", "disabled", "appearance"] }, { kind: "directive", type: i5.LegacyFormlyAttributes, selector: "[formlyAttributes]" }, { kind: "pipe", type: i1.AsyncPipe, name: "async" }, { kind: "pipe", type: i6.LegacyFormlySelectOptionsPipe, name: "formlySelectOptions" }], changeDetection: i0.ChangeDetectionStrategy.OnPush }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyFieldSelect, decorators: [{
            type: Component,
            args: [{
                    selector: 'formly-field-mat-select',
                    template: `
    <ng-template #selectAll let-selectOptions="selectOptions">
      <mat-option (click)="toggleSelectAll(selectOptions)">
        <mat-pseudo-checkbox class="mat-option-pseudo-checkbox" [state]="getSelectAllState(selectOptions)">
        </mat-pseudo-checkbox>
        {{ props.selectAllOption }}
      </mat-option>
    </ng-template>

    <mat-select
      [id]="id"
      [formControl]="formControl"
      [formlyAttributes]="field"
      [placeholder]="props.placeholder"
      [tabIndex]="props.tabindex"
      [required]="required"
      [compareWith]="props.compareWith"
      [multiple]="props.multiple"
      (selectionChange)="change($event)"
      [errorStateMatcher]="errorStateMatcher"
      [aria-label]="_getAriaLabel()"
      [aria-labelledby]="_getAriaLabelledby()"
      [disableOptionCentering]="props.disableOptionCentering"
      [typeaheadDebounceInterval]="props.typeaheadDebounceInterval"
      [panelClass]="props.panelClass"
    >
      @if (props.options | formlySelectOptions: field | async; as selectOptions) {
        @if (props.multiple && props.selectAllOption) {
          <ng-container [ngTemplateOutlet]="selectAll" [ngTemplateOutletContext]="{ selectOptions: selectOptions }">
          </ng-container>
        }
        @for (item of selectOptions; track $index) {
          @if (item.group) {
            <mat-optgroup [label]="item.label">
              @for (child of item.group; track $index) {
                <mat-option [value]="child.value" [disabled]="child.disabled">
                  {{ child.label }}
                </mat-option>
              }
            </mat-optgroup>
          } @else {
            <mat-option [value]="item.value" [disabled]="item.disabled">{{ item.label }}</mat-option>
          }
        }
      }
    </mat-select>
  `,
                    changeDetection: ChangeDetectionStrategy.OnPush,
                }]
        }], propDecorators: { select: [{
                type: ViewChild,
                args: [MatSelect, { static: true }]
            }] } });
//# sourceMappingURL=data:application/json;base64,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