import { Component, ChangeDetectionStrategy, ViewChild } from '@angular/core';
import { ɵobserve as observe } from '@ngx-formly/core';
import { FieldType } from '@ngx-formly/material/form-field';
import { MatRadioGroup } from '@angular/material/radio';
import * as i0 from "@angular/core";
import * as i1 from "@angular/forms";
import * as i2 from "@angular/material/radio";
import * as i3 from "@ngx-formly/core";
import * as i4 from "@angular/common";
import * as i5 from "@ngx-formly/core/select";
export class FormlyFieldRadio extends FieldType {
    constructor() {
        super(...arguments);
        this.defaultOptions = {
            props: {
                hideFieldUnderline: true,
                floatLabel: 'always',
                tabindex: -1,
            },
        };
    }
    ngAfterViewInit() {
        this.focusObserver = observe(this.field, ['focus'], ({ currentValue }) => {
            if (this.props.tabindex === -1 && currentValue && this.radioGroup._radios.length > 0) {
                // https://github.com/ngx-formly/ngx-formly/issues/2498
                setTimeout(() => {
                    const radio = this.radioGroup.selected ? this.radioGroup.selected : this.radioGroup._radios.first;
                    radio.focus();
                });
            }
        });
    }
    // TODO: find a solution to prevent scroll on focus
    onContainerClick() { }
    ngOnDestroy() {
        super.ngOnDestroy();
        this.focusObserver && this.focusObserver.unsubscribe();
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyFieldRadio, deps: null, target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "17.0.0", version: "18.2.13", type: FormlyFieldRadio, selector: "formly-field-mat-radio", viewQueries: [{ propertyName: "radioGroup", first: true, predicate: MatRadioGroup, descendants: true, static: true }], usesInheritance: true, ngImport: i0, template: `
    <mat-radio-group
      [formControl]="formControl"
      [formlyAttributes]="field"
      [required]="required"
      [tabindex]="props.tabindex"
    >
      @for (option of props.options | formlySelectOptions: field | async; track $index; let i = $index) {
        <mat-radio-button
          [id]="id + '_' + i"
          [color]="props.color"
          [labelPosition]="props.labelPosition"
          [disabled]="option.disabled"
          [value]="option.value"
        >
          {{ option.label }}
        </mat-radio-button>
      }
    </mat-radio-group>
  `, isInline: true, dependencies: [{ kind: "directive", type: i1.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i1.RequiredValidator, selector: ":not([type=checkbox])[required][formControlName],:not([type=checkbox])[required][formControl],:not([type=checkbox])[required][ngModel]", inputs: ["required"] }, { kind: "directive", type: i1.FormControlDirective, selector: "[formControl]", inputs: ["formControl", "disabled", "ngModel"], outputs: ["ngModelChange"], exportAs: ["ngForm"] }, { kind: "directive", type: i2.MatRadioGroup, selector: "mat-radio-group", inputs: ["color", "name", "labelPosition", "value", "selected", "disabled", "required", "disabledInteractive"], outputs: ["change"], exportAs: ["matRadioGroup"] }, { kind: "component", type: i2.MatRadioButton, selector: "mat-radio-button", inputs: ["id", "name", "aria-label", "aria-labelledby", "aria-describedby", "disableRipple", "tabIndex", "checked", "value", "labelPosition", "disabled", "required", "color", "disabledInteractive"], outputs: ["change"], exportAs: ["matRadioButton"] }, { kind: "directive", type: i3.LegacyFormlyAttributes, selector: "[formlyAttributes]" }, { kind: "pipe", type: i4.AsyncPipe, name: "async" }, { kind: "pipe", type: i5.LegacyFormlySelectOptionsPipe, name: "formlySelectOptions" }], changeDetection: i0.ChangeDetectionStrategy.OnPush }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyFieldRadio, decorators: [{
            type: Component,
            args: [{
                    selector: 'formly-field-mat-radio',
                    template: `
    <mat-radio-group
      [formControl]="formControl"
      [formlyAttributes]="field"
      [required]="required"
      [tabindex]="props.tabindex"
    >
      @for (option of props.options | formlySelectOptions: field | async; track $index; let i = $index) {
        <mat-radio-button
          [id]="id + '_' + i"
          [color]="props.color"
          [labelPosition]="props.labelPosition"
          [disabled]="option.disabled"
          [value]="option.value"
        >
          {{ option.label }}
        </mat-radio-button>
      }
    </mat-radio-group>
  `,
                    changeDetection: ChangeDetectionStrategy.OnPush,
                }]
        }], propDecorators: { radioGroup: [{
                type: ViewChild,
                args: [MatRadioGroup, { static: true }]
            }] } });
//# sourceMappingURL=data:application/json;base64,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