import { Component, ChangeDetectionStrategy, ViewChildren } from '@angular/core';
import { MatCheckbox } from '@angular/material/checkbox';
import { FieldType } from '@ngx-formly/material/form-field';
import * as i0 from "@angular/core";
import * as i1 from "@angular/material/checkbox";
import * as i2 from "@ngx-formly/core";
import * as i3 from "@angular/common";
import * as i4 from "@ngx-formly/core/select";
export class FormlyFieldMultiCheckbox extends FieldType {
    constructor() {
        super(...arguments);
        this.defaultOptions = {
            props: {
                hideFieldUnderline: true,
                floatLabel: 'always',
                color: 'accent', // workaround for https://github.com/angular/components/issues/18465
            },
        };
    }
    onChange(value, checked) {
        this.formControl.markAsDirty();
        if (this.props.type === 'array') {
            this.formControl.patchValue(checked
                ? [...(this.formControl.value || []), value]
                : [...(this.formControl.value || [])].filter((o) => o !== value));
        }
        else {
            this.formControl.patchValue({ ...this.formControl.value, [value]: checked });
        }
        this.formControl.markAsTouched();
    }
    // TODO: find a solution to prevent scroll on focus
    onContainerClick() { }
    isChecked(option) {
        const value = this.formControl.value;
        return value && (this.props.type === 'array' ? value.indexOf(option.value) !== -1 : value[option.value]);
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyFieldMultiCheckbox, deps: null, target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "17.0.0", version: "18.2.13", type: FormlyFieldMultiCheckbox, selector: "formly-field-mat-multicheckbox", host: { properties: { "id": "id" } }, viewQueries: [{ propertyName: "checkboxes", predicate: MatCheckbox, descendants: true }], usesInheritance: true, ngImport: i0, template: `
    @for (option of props.options | formlySelectOptions: field | async; track $index; let i = $index) {
      <mat-checkbox
        [id]="id + '_' + i"
        [formlyAttributes]="field"
        [tabIndex]="props.tabindex"
        [color]="props.color"
        [labelPosition]="props.labelPosition"
        [checked]="isChecked(option)"
        [disabled]="formControl.disabled || option.disabled"
        (change)="onChange(option.value, $event.checked)"
      >
        {{ option.label }}
      </mat-checkbox>
    }
  `, isInline: true, dependencies: [{ kind: "component", type: i1.MatCheckbox, selector: "mat-checkbox", inputs: ["aria-label", "aria-labelledby", "aria-describedby", "id", "required", "labelPosition", "name", "value", "disableRipple", "tabIndex", "color", "disabledInteractive", "checked", "disabled", "indeterminate"], outputs: ["change", "indeterminateChange"], exportAs: ["matCheckbox"] }, { kind: "directive", type: i2.LegacyFormlyAttributes, selector: "[formlyAttributes]" }, { kind: "pipe", type: i3.AsyncPipe, name: "async" }, { kind: "pipe", type: i4.LegacyFormlySelectOptionsPipe, name: "formlySelectOptions" }], changeDetection: i0.ChangeDetectionStrategy.OnPush }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyFieldMultiCheckbox, decorators: [{
            type: Component,
            args: [{
                    selector: 'formly-field-mat-multicheckbox',
                    template: `
    @for (option of props.options | formlySelectOptions: field | async; track $index; let i = $index) {
      <mat-checkbox
        [id]="id + '_' + i"
        [formlyAttributes]="field"
        [tabIndex]="props.tabindex"
        [color]="props.color"
        [labelPosition]="props.labelPosition"
        [checked]="isChecked(option)"
        [disabled]="formControl.disabled || option.disabled"
        (change)="onChange(option.value, $event.checked)"
      >
        {{ option.label }}
      </mat-checkbox>
    }
  `,
                    changeDetection: ChangeDetectionStrategy.OnPush,
                    host: {
                        '[id]': 'id',
                    },
                }]
        }], propDecorators: { checkboxes: [{
                type: ViewChildren,
                args: [MatCheckbox]
            }] } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibXVsdGljaGVja2JveC50eXBlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vc3JjL3VpL21hdGVyaWFsL211bHRpY2hlY2tib3gvc3JjL211bHRpY2hlY2tib3gudHlwZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLEVBQUUsU0FBUyxFQUFFLHVCQUF1QixFQUFFLFlBQVksRUFBbUIsTUFBTSxlQUFlLENBQUM7QUFFbEcsT0FBTyxFQUFFLFdBQVcsRUFBRSxNQUFNLDRCQUE0QixDQUFDO0FBQ3pELE9BQU8sRUFBRSxTQUFTLEVBQW9CLE1BQU0saUNBQWlDLENBQUM7Ozs7OztBQWlDOUUsTUFBTSxPQUFPLHdCQUF5QixTQUFRLFNBQThDO0lBdkI1Rjs7UUEwQlcsbUJBQWMsR0FBRztZQUN4QixLQUFLLEVBQUU7Z0JBQ0wsa0JBQWtCLEVBQUUsSUFBSTtnQkFDeEIsVUFBVSxFQUFFLFFBQWlCO2dCQUM3QixLQUFLLEVBQUUsUUFBaUIsRUFBRSxvRUFBb0U7YUFDL0Y7U0FDRixDQUFDO0tBd0JIO0lBdEJDLFFBQVEsQ0FBQyxLQUFVLEVBQUUsT0FBZ0I7UUFDbkMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxXQUFXLEVBQUUsQ0FBQztRQUMvQixJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxLQUFLLE9BQU8sRUFBRSxDQUFDO1lBQ2hDLElBQUksQ0FBQyxXQUFXLENBQUMsVUFBVSxDQUN6QixPQUFPO2dCQUNMLENBQUMsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLEtBQUssSUFBSSxFQUFFLENBQUMsRUFBRSxLQUFLLENBQUM7Z0JBQzVDLENBQUMsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLEtBQUssSUFBSSxFQUFFLENBQUMsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxLQUFLLEtBQUssQ0FBQyxDQUNuRSxDQUFDO1FBQ0osQ0FBQzthQUFNLENBQUM7WUFDTixJQUFJLENBQUMsV0FBVyxDQUFDLFVBQVUsQ0FBQyxFQUFFLEdBQUcsSUFBSSxDQUFDLFdBQVcsQ0FBQyxLQUFLLEVBQUUsQ0FBQyxLQUFLLENBQUMsRUFBRSxPQUFPLEVBQUUsQ0FBQyxDQUFDO1FBQy9FLENBQUM7UUFDRCxJQUFJLENBQUMsV0FBVyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQ25DLENBQUM7SUFFRCxtREFBbUQ7SUFDMUMsZ0JBQWdCLEtBQUksQ0FBQztJQUU5QixTQUFTLENBQUMsTUFBVztRQUNuQixNQUFNLEtBQUssR0FBRyxJQUFJLENBQUMsV0FBVyxDQUFDLEtBQUssQ0FBQztRQUVyQyxPQUFPLEtBQUssSUFBSSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxLQUFLLE9BQU8sQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxNQUFNLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztJQUMzRyxDQUFDOytHQWhDVSx3QkFBd0I7bUdBQXhCLHdCQUF3QiwySUFDckIsV0FBVyx1RUF0QmY7Ozs7Ozs7Ozs7Ozs7OztHQWVUOzs0RkFNVSx3QkFBd0I7a0JBdkJwQyxTQUFTO21CQUFDO29CQUNULFFBQVEsRUFBRSxnQ0FBZ0M7b0JBQzFDLFFBQVEsRUFBRTs7Ozs7Ozs7Ozs7Ozs7O0dBZVQ7b0JBQ0QsZUFBZSxFQUFFLHVCQUF1QixDQUFDLE1BQU07b0JBQy9DLElBQUksRUFBRTt3QkFDSixNQUFNLEVBQUUsSUFBSTtxQkFDYjtpQkFDRjs4QkFFNEIsVUFBVTtzQkFBcEMsWUFBWTt1QkFBQyxXQUFXIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29tcG9uZW50LCBDaGFuZ2VEZXRlY3Rpb25TdHJhdGVneSwgVmlld0NoaWxkcmVuLCBRdWVyeUxpc3QsIFR5cGUgfSBmcm9tICdAYW5ndWxhci9jb3JlJztcbmltcG9ydCB7IEZpZWxkVHlwZUNvbmZpZywgRm9ybWx5RmllbGRDb25maWcgfSBmcm9tICdAbmd4LWZvcm1seS9jb3JlJztcbmltcG9ydCB7IE1hdENoZWNrYm94IH0gZnJvbSAnQGFuZ3VsYXIvbWF0ZXJpYWwvY2hlY2tib3gnO1xuaW1wb3J0IHsgRmllbGRUeXBlLCBGb3JtbHlGaWVsZFByb3BzIH0gZnJvbSAnQG5neC1mb3JtbHkvbWF0ZXJpYWwvZm9ybS1maWVsZCc7XG5cbmludGVyZmFjZSBNdWx0aUNoZWNrYm94UHJvcHMgZXh0ZW5kcyBGb3JtbHlGaWVsZFByb3BzIHtcbiAgbGFiZWxQb3NpdGlvbj86ICdiZWZvcmUnIHwgJ2FmdGVyJztcbn1cblxuZXhwb3J0IGludGVyZmFjZSBGb3JtbHlNdWx0aUNoZWNrYm94RmllbGRDb25maWcgZXh0ZW5kcyBGb3JtbHlGaWVsZENvbmZpZzxNdWx0aUNoZWNrYm94UHJvcHM+IHtcbiAgdHlwZTogJ211bHRpY2hlY2tib3gnIHwgVHlwZTxGb3JtbHlGaWVsZE11bHRpQ2hlY2tib3g+O1xufVxuXG5AQ29tcG9uZW50KHtcbiAgc2VsZWN0b3I6ICdmb3JtbHktZmllbGQtbWF0LW11bHRpY2hlY2tib3gnLFxuICB0ZW1wbGF0ZTogYFxuICAgIEBmb3IgKG9wdGlvbiBvZiBwcm9wcy5vcHRpb25zIHwgZm9ybWx5U2VsZWN0T3B0aW9uczogZmllbGQgfCBhc3luYzsgdHJhY2sgJGluZGV4OyBsZXQgaSA9ICRpbmRleCkge1xuICAgICAgPG1hdC1jaGVja2JveFxuICAgICAgICBbaWRdPVwiaWQgKyAnXycgKyBpXCJcbiAgICAgICAgW2Zvcm1seUF0dHJpYnV0ZXNdPVwiZmllbGRcIlxuICAgICAgICBbdGFiSW5kZXhdPVwicHJvcHMudGFiaW5kZXhcIlxuICAgICAgICBbY29sb3JdPVwicHJvcHMuY29sb3JcIlxuICAgICAgICBbbGFiZWxQb3NpdGlvbl09XCJwcm9wcy5sYWJlbFBvc2l0aW9uXCJcbiAgICAgICAgW2NoZWNrZWRdPVwiaXNDaGVja2VkKG9wdGlvbilcIlxuICAgICAgICBbZGlzYWJsZWRdPVwiZm9ybUNvbnRyb2wuZGlzYWJsZWQgfHwgb3B0aW9uLmRpc2FibGVkXCJcbiAgICAgICAgKGNoYW5nZSk9XCJvbkNoYW5nZShvcHRpb24udmFsdWUsICRldmVudC5jaGVja2VkKVwiXG4gICAgICA+XG4gICAgICAgIHt7IG9wdGlvbi5sYWJlbCB9fVxuICAgICAgPC9tYXQtY2hlY2tib3g+XG4gICAgfVxuICBgLFxuICBjaGFuZ2VEZXRlY3Rpb246IENoYW5nZURldGVjdGlvblN0cmF0ZWd5Lk9uUHVzaCxcbiAgaG9zdDoge1xuICAgICdbaWRdJzogJ2lkJyxcbiAgfSxcbn0pXG5leHBvcnQgY2xhc3MgRm9ybWx5RmllbGRNdWx0aUNoZWNrYm94IGV4dGVuZHMgRmllbGRUeXBlPEZpZWxkVHlwZUNvbmZpZzxNdWx0aUNoZWNrYm94UHJvcHM+PiB7XG4gIEBWaWV3Q2hpbGRyZW4oTWF0Q2hlY2tib3gpIGNoZWNrYm94ZXMhOiBRdWVyeUxpc3Q8TWF0Q2hlY2tib3g+O1xuXG4gIG92ZXJyaWRlIGRlZmF1bHRPcHRpb25zID0ge1xuICAgIHByb3BzOiB7XG4gICAgICBoaWRlRmllbGRVbmRlcmxpbmU6IHRydWUsXG4gICAgICBmbG9hdExhYmVsOiAnYWx3YXlzJyBhcyBjb25zdCxcbiAgICAgIGNvbG9yOiAnYWNjZW50JyBhcyBjb25zdCwgLy8gd29ya2Fyb3VuZCBmb3IgaHR0cHM6Ly9naXRodWIuY29tL2FuZ3VsYXIvY29tcG9uZW50cy9pc3N1ZXMvMTg0NjVcbiAgICB9LFxuICB9O1xuXG4gIG9uQ2hhbmdlKHZhbHVlOiBhbnksIGNoZWNrZWQ6IGJvb2xlYW4pIHtcbiAgICB0aGlzLmZvcm1Db250cm9sLm1hcmtBc0RpcnR5KCk7XG4gICAgaWYgKHRoaXMucHJvcHMudHlwZSA9PT0gJ2FycmF5Jykge1xuICAgICAgdGhpcy5mb3JtQ29udHJvbC5wYXRjaFZhbHVlKFxuICAgICAgICBjaGVja2VkXG4gICAgICAgICAgPyBbLi4uKHRoaXMuZm9ybUNvbnRyb2wudmFsdWUgfHwgW10pLCB2YWx1ZV1cbiAgICAgICAgICA6IFsuLi4odGhpcy5mb3JtQ29udHJvbC52YWx1ZSB8fCBbXSldLmZpbHRlcigobykgPT4gbyAhPT0gdmFsdWUpLFxuICAgICAgKTtcbiAgICB9IGVsc2Uge1xuICAgICAgdGhpcy5mb3JtQ29udHJvbC5wYXRjaFZhbHVlKHsgLi4udGhpcy5mb3JtQ29udHJvbC52YWx1ZSwgW3ZhbHVlXTogY2hlY2tlZCB9KTtcbiAgICB9XG4gICAgdGhpcy5mb3JtQ29udHJvbC5tYXJrQXNUb3VjaGVkKCk7XG4gIH1cblxuICAvLyBUT0RPOiBmaW5kIGEgc29sdXRpb24gdG8gcHJldmVudCBzY3JvbGwgb24gZm9jdXNcbiAgb3ZlcnJpZGUgb25Db250YWluZXJDbGljaygpIHt9XG5cbiAgaXNDaGVja2VkKG9wdGlvbjogYW55KSB7XG4gICAgY29uc3QgdmFsdWUgPSB0aGlzLmZvcm1Db250cm9sLnZhbHVlO1xuXG4gICAgcmV0dXJuIHZhbHVlICYmICh0aGlzLnByb3BzLnR5cGUgPT09ICdhcnJheScgPyB2YWx1ZS5pbmRleE9mKG9wdGlvbi52YWx1ZSkgIT09IC0xIDogdmFsdWVbb3B0aW9uLnZhbHVlXSk7XG4gIH1cbn1cbiJdfQ==