import { FormlyFieldInput } from './input.type';
export function withFormlyFieldInput() {
    return {
        types: [
            {
                name: 'input',
                component: FormlyFieldInput,
                wrappers: ['form-field'],
            },
            { name: 'string', extends: 'input' },
            {
                name: 'number',
                extends: 'input',
                defaultOptions: {
                    props: {
                        type: 'number',
                    },
                },
            },
            {
                name: 'integer',
                extends: 'input',
                defaultOptions: {
                    props: {
                        type: 'number',
                    },
                },
            },
        ],
    };
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5wdXQuY29uZmlnLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vc3JjL3VpL21hdGVyaWFsL2lucHV0L3NyYy9pbnB1dC5jb25maWcudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQ0EsT0FBTyxFQUFFLGdCQUFnQixFQUFFLE1BQU0sY0FBYyxDQUFDO0FBRWhELE1BQU0sVUFBVSxvQkFBb0I7SUFDbEMsT0FBTztRQUNMLEtBQUssRUFBRTtZQUNMO2dCQUNFLElBQUksRUFBRSxPQUFPO2dCQUNiLFNBQVMsRUFBRSxnQkFBZ0I7Z0JBQzNCLFFBQVEsRUFBRSxDQUFDLFlBQVksQ0FBQzthQUN6QjtZQUNELEVBQUUsSUFBSSxFQUFFLFFBQVEsRUFBRSxPQUFPLEVBQUUsT0FBTyxFQUFFO1lBQ3BDO2dCQUNFLElBQUksRUFBRSxRQUFRO2dCQUNkLE9BQU8sRUFBRSxPQUFPO2dCQUNoQixjQUFjLEVBQUU7b0JBQ2QsS0FBSyxFQUFFO3dCQUNMLElBQUksRUFBRSxRQUFRO3FCQUNmO2lCQUNGO2FBQ0Y7WUFDRDtnQkFDRSxJQUFJLEVBQUUsU0FBUztnQkFDZixPQUFPLEVBQUUsT0FBTztnQkFDaEIsY0FBYyxFQUFFO29CQUNkLEtBQUssRUFBRTt3QkFDTCxJQUFJLEVBQUUsUUFBUTtxQkFDZjtpQkFDRjthQUNGO1NBQ0Y7S0FDRixDQUFDO0FBQ0osQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbmZpZ09wdGlvbiB9IGZyb20gJ0BuZ3gtZm9ybWx5L2NvcmUnO1xuaW1wb3J0IHsgRm9ybWx5RmllbGRJbnB1dCB9IGZyb20gJy4vaW5wdXQudHlwZSc7XG5cbmV4cG9ydCBmdW5jdGlvbiB3aXRoRm9ybWx5RmllbGRJbnB1dCgpOiBDb25maWdPcHRpb24ge1xuICByZXR1cm4ge1xuICAgIHR5cGVzOiBbXG4gICAgICB7XG4gICAgICAgIG5hbWU6ICdpbnB1dCcsXG4gICAgICAgIGNvbXBvbmVudDogRm9ybWx5RmllbGRJbnB1dCxcbiAgICAgICAgd3JhcHBlcnM6IFsnZm9ybS1maWVsZCddLFxuICAgICAgfSxcbiAgICAgIHsgbmFtZTogJ3N0cmluZycsIGV4dGVuZHM6ICdpbnB1dCcgfSxcbiAgICAgIHtcbiAgICAgICAgbmFtZTogJ251bWJlcicsXG4gICAgICAgIGV4dGVuZHM6ICdpbnB1dCcsXG4gICAgICAgIGRlZmF1bHRPcHRpb25zOiB7XG4gICAgICAgICAgcHJvcHM6IHtcbiAgICAgICAgICAgIHR5cGU6ICdudW1iZXInLFxuICAgICAgICAgIH0sXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgICAge1xuICAgICAgICBuYW1lOiAnaW50ZWdlcicsXG4gICAgICAgIGV4dGVuZHM6ICdpbnB1dCcsXG4gICAgICAgIGRlZmF1bHRPcHRpb25zOiB7XG4gICAgICAgICAgcHJvcHM6IHtcbiAgICAgICAgICAgIHR5cGU6ICdudW1iZXInLFxuICAgICAgICAgIH0sXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgIF0sXG4gIH07XG59XG4iXX0=