import { Component, ViewChild, ViewEncapsulation, } from '@angular/core';
import { ɵdefineHiddenProp as defineHiddenProp, FieldWrapper, } from '@ngx-formly/core';
import { MatFormField } from '@angular/material/form-field';
import * as i0 from "@angular/core";
import * as i1 from "@angular/cdk/a11y";
import * as i2 from "@angular/common";
import * as i3 from "@angular/material/form-field";
import * as i4 from "@ngx-formly/core";
export class FormlyWrapperFormField extends FieldWrapper {
    constructor(renderer, elementRef, focusMonitor) {
        super();
        this.renderer = renderer;
        this.elementRef = elementRef;
        this.focusMonitor = focusMonitor;
    }
    ngOnInit() {
        defineHiddenProp(this.field, '_formField', this.formField);
        this.focusMonitor.monitor(this.elementRef, true).subscribe((origin) => {
            if (!origin && this.field.focus) {
                this.field.focus = false;
            }
        });
    }
    ngAfterViewInit() {
        // temporary fix for https://github.com/angular/material2/issues/7891
        if (this.formField.appearance !== 'outline' && this.props.hideFieldUnderline === true) {
            const underlineElement = this.formField._elementRef.nativeElement.querySelector('.mat-form-field-underline');
            underlineElement && this.renderer.removeChild(underlineElement.parentNode, underlineElement);
        }
    }
    ngOnDestroy() {
        delete this.field._formField;
        this.focusMonitor.stopMonitoring(this.elementRef);
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyWrapperFormField, deps: [{ token: i0.Renderer2 }, { token: i0.ElementRef }, { token: i1.FocusMonitor }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "17.0.0", version: "18.2.13", type: FormlyWrapperFormField, selector: "formly-wrapper-mat-form-field", viewQueries: [{ propertyName: "formField", first: true, predicate: MatFormField, descendants: true, static: true }], usesInheritance: true, ngImport: i0, template: `
    <!-- fix https://github.com/angular/material2/pull/7083 by setting width to 100% -->
    <mat-form-field
      [hideRequiredMarker]="true"
      [floatLabel]="props.floatLabel"
      [appearance]="props.appearance"
      [subscriptSizing]="props.subscriptSizing"
      [color]="props.color ?? 'primary'"
    >
      <ng-container #fieldComponent></ng-container>
      @if (props.label && props.hideLabel !== true) {
        <mat-label>
          {{ props.label }}
          @if (props.required && props.hideRequiredMarker !== true) {
            <span aria-hidden="true" class="mat-form-field-required-marker mat-mdc-form-field-required-marker">*</span>
          }
        </mat-label>
      }

      @if (props.textPrefix) {
        <ng-container
          matTextPrefix
          [ngTemplateOutlet]="props.textPrefix"
          [ngTemplateOutletContext]="{ field: field }"
        ></ng-container>
      }

      @if (props.prefix) {
        <ng-container
          matPrefix
          [ngTemplateOutlet]="props.prefix"
          [ngTemplateOutletContext]="{ field: field }"
        ></ng-container>
      }

      @if (props.textSuffix) {
        <ng-container
          matTextSuffix
          [ngTemplateOutlet]="props.textSuffix"
          [ngTemplateOutletContext]="{ field: field }"
        ></ng-container>
      }

      @if (props.suffix) {
        <ng-container
          matSuffix
          [ngTemplateOutlet]="props.suffix"
          [ngTemplateOutletContext]="{ field: field }"
        ></ng-container>
      }

      <mat-error>
        <formly-validation-message [field]="field"></formly-validation-message>
      </mat-error>

      @if (props.description || props.hintStart; as hint) {
        <mat-hint>
          <ng-container [ngTemplateOutlet]="stringOrTemplate" [ngTemplateOutletContext]="{ content: hint }">
          </ng-container>
        </mat-hint>
      }

      @if (props.hintEnd; as hintEnd) {
        <mat-hint align="end">
          <ng-container [ngTemplateOutlet]="stringOrTemplate" [ngTemplateOutletContext]="{ content: hintEnd }">
          </ng-container>
        </mat-hint>
      }
    </mat-form-field>

    <ng-template #stringOrTemplate let-content="content">
      @if (!content.createEmbeddedView) {
        {{ content }}
      } @else {
        <ng-container [ngTemplateOutlet]="content" [ngTemplateOutletContext]="{ field: field }"></ng-container>
      }
    </ng-template>
  `, isInline: true, styles: ["formly-wrapper-mat-form-field .mat-mdc-form-field,formly-wrapper-mat-form-field .mat-form-field{width:100%}\n"], dependencies: [{ kind: "directive", type: i2.NgTemplateOutlet, selector: "[ngTemplateOutlet]", inputs: ["ngTemplateOutletContext", "ngTemplateOutlet", "ngTemplateOutletInjector"] }, { kind: "component", type: i3.MatFormField, selector: "mat-form-field", inputs: ["hideRequiredMarker", "color", "floatLabel", "appearance", "subscriptSizing", "hintLabel"], exportAs: ["matFormField"] }, { kind: "directive", type: i3.MatLabel, selector: "mat-label" }, { kind: "directive", type: i3.MatHint, selector: "mat-hint", inputs: ["align", "id"] }, { kind: "directive", type: i3.MatError, selector: "mat-error, [matError]", inputs: ["id"] }, { kind: "directive", type: i3.MatPrefix, selector: "[matPrefix], [matIconPrefix], [matTextPrefix]", inputs: ["matTextPrefix"] }, { kind: "directive", type: i3.MatSuffix, selector: "[matSuffix], [matIconSuffix], [matTextSuffix]", inputs: ["matTextSuffix"] }, { kind: "component", type: i4.LegacyFormlyValidationMessage, selector: "formly-validation-message" }], encapsulation: i0.ViewEncapsulation.None }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyWrapperFormField, decorators: [{
            type: Component,
            args: [{ selector: 'formly-wrapper-mat-form-field', template: `
    <!-- fix https://github.com/angular/material2/pull/7083 by setting width to 100% -->
    <mat-form-field
      [hideRequiredMarker]="true"
      [floatLabel]="props.floatLabel"
      [appearance]="props.appearance"
      [subscriptSizing]="props.subscriptSizing"
      [color]="props.color ?? 'primary'"
    >
      <ng-container #fieldComponent></ng-container>
      @if (props.label && props.hideLabel !== true) {
        <mat-label>
          {{ props.label }}
          @if (props.required && props.hideRequiredMarker !== true) {
            <span aria-hidden="true" class="mat-form-field-required-marker mat-mdc-form-field-required-marker">*</span>
          }
        </mat-label>
      }

      @if (props.textPrefix) {
        <ng-container
          matTextPrefix
          [ngTemplateOutlet]="props.textPrefix"
          [ngTemplateOutletContext]="{ field: field }"
        ></ng-container>
      }

      @if (props.prefix) {
        <ng-container
          matPrefix
          [ngTemplateOutlet]="props.prefix"
          [ngTemplateOutletContext]="{ field: field }"
        ></ng-container>
      }

      @if (props.textSuffix) {
        <ng-container
          matTextSuffix
          [ngTemplateOutlet]="props.textSuffix"
          [ngTemplateOutletContext]="{ field: field }"
        ></ng-container>
      }

      @if (props.suffix) {
        <ng-container
          matSuffix
          [ngTemplateOutlet]="props.suffix"
          [ngTemplateOutletContext]="{ field: field }"
        ></ng-container>
      }

      <mat-error>
        <formly-validation-message [field]="field"></formly-validation-message>
      </mat-error>

      @if (props.description || props.hintStart; as hint) {
        <mat-hint>
          <ng-container [ngTemplateOutlet]="stringOrTemplate" [ngTemplateOutletContext]="{ content: hint }">
          </ng-container>
        </mat-hint>
      }

      @if (props.hintEnd; as hintEnd) {
        <mat-hint align="end">
          <ng-container [ngTemplateOutlet]="stringOrTemplate" [ngTemplateOutletContext]="{ content: hintEnd }">
          </ng-container>
        </mat-hint>
      }
    </mat-form-field>

    <ng-template #stringOrTemplate let-content="content">
      @if (!content.createEmbeddedView) {
        {{ content }}
      } @else {
        <ng-container [ngTemplateOutlet]="content" [ngTemplateOutletContext]="{ field: field }"></ng-container>
      }
    </ng-template>
  `, encapsulation: ViewEncapsulation.None, styles: ["formly-wrapper-mat-form-field .mat-mdc-form-field,formly-wrapper-mat-form-field .mat-form-field{width:100%}\n"] }]
        }], ctorParameters: () => [{ type: i0.Renderer2 }, { type: i0.ElementRef }, { type: i1.FocusMonitor }], propDecorators: { formField: [{
                type: ViewChild,
                args: [MatFormField, { static: true }]
            }] } });
//# sourceMappingURL=data:application/json;base64,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