import { ViewChild, Type, Directive, ViewChildren } from '@angular/core';
import { FieldType as CoreFieldType, ɵobserve as observe } from '@ngx-formly/core';
import { Subject } from 'rxjs';
import { MatFormFieldControl } from '@angular/material/form-field';
import * as i0 from "@angular/core";
export class FieldType extends CoreFieldType {
    constructor() {
        super(...arguments);
        this.errorStateMatcher = { isErrorState: () => this.field && this.showError };
        this.stateChanges = new Subject();
        this._errorState = false;
        this._focused = false;
    }
    set matPrefix(prefix) {
        if (prefix) {
            this.props.prefix = prefix;
        }
    }
    set matTextPrefix(textPrefix) {
        if (textPrefix) {
            this.props.textPrefix = textPrefix;
        }
    }
    set matSuffix(suffix) {
        if (suffix) {
            this.props.suffix = suffix;
        }
    }
    set matTextSuffix(textSuffix) {
        if (textSuffix) {
            this.props.textSuffix = textSuffix;
        }
    }
    set _controls(controls) {
        this.attachControl(controls.length === 1 ? controls.first : this);
    }
    ngOnDestroy() {
        delete this.formField?._control;
        this.stateChanges.complete();
    }
    setDescribedByIds(_ids) { }
    onContainerClick(_event) {
        this.field.focus = true;
        this.stateChanges.next();
    }
    get errorState() {
        const showError = this.options.showError(this);
        if (showError !== this._errorState) {
            this._errorState = showError;
            this.stateChanges.next();
        }
        return showError;
    }
    get controlType() {
        if (this.props.type) {
            return this.props.type;
        }
        const type = this.field.type;
        return type instanceof Type ? type.prototype.constructor.name : type;
    }
    get focused() {
        const focused = !!this.field.focus && !this.disabled;
        if (focused !== this._focused) {
            this._focused = focused;
            this.stateChanges.next();
        }
        return focused;
    }
    get disabled() {
        return !!this.props.disabled;
    }
    get required() {
        return !!this.props.required;
    }
    get placeholder() {
        return this.props.placeholder || '';
    }
    get shouldPlaceholderFloat() {
        return this.shouldLabelFloat;
    }
    get value() {
        return this.formControl?.value;
    }
    set value(value) {
        this.formControl?.patchValue(value);
    }
    get ngControl() {
        return this.formControl;
    }
    get empty() {
        return this.value == null || this.value === '';
    }
    get shouldLabelFloat() {
        return this.focused || !this.empty;
    }
    get formField() {
        return this.field?.['_formField'];
    }
    attachControl(control) {
        if (this.formField && control !== this.formField._control) {
            this.formField._control = control;
            // temporary fix for https://github.com/angular/material2/issues/6728
            const ngControl = control?.ngControl;
            if (ngControl?.valueAccessor?.hasOwnProperty('_formField')) {
                ngControl.valueAccessor['_formField'] = this.formField;
            }
            if (ngControl?.valueAccessor?.hasOwnProperty('_parentFormField')) {
                ngControl.valueAccessor['_parentFormField'] = this.formField;
            }
            ['prefix', 'suffix', 'textPrefix', 'textSuffix'].forEach((type) => observe(this.field, ['props', type], ({ currentValue }) => currentValue &&
                Promise.resolve().then(() => {
                    this.options.detectChanges(this.field);
                })));
            // https://github.com/angular/components/issues/16209
            const setDescribedByIds = control.setDescribedByIds.bind(control);
            control.setDescribedByIds = (ids) => {
                setTimeout(() => setDescribedByIds(ids));
            };
        }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FieldType, deps: null, target: i0.ɵɵFactoryTarget.Directive }); }
    static { this.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "18.2.13", type: FieldType, viewQueries: [{ propertyName: "matPrefix", first: true, predicate: ["matPrefix"], descendants: true }, { propertyName: "matTextPrefix", first: true, predicate: ["matTextPrefix"], descendants: true }, { propertyName: "matSuffix", first: true, predicate: ["matSuffix"], descendants: true }, { propertyName: "matTextSuffix", first: true, predicate: ["matTextSuffix"], descendants: true }, { propertyName: "_controls", predicate: MatFormFieldControl, descendants: true }], usesInheritance: true, ngImport: i0 }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FieldType, decorators: [{
            type: Directive
        }], propDecorators: { matPrefix: [{
                type: ViewChild,
                args: ['matPrefix']
            }], matTextPrefix: [{
                type: ViewChild,
                args: ['matTextPrefix']
            }], matSuffix: [{
                type: ViewChild,
                args: ['matSuffix']
            }], matTextSuffix: [{
                type: ViewChild,
                args: ['matTextSuffix']
            }], _controls: [{
                type: ViewChildren,
                args: [MatFormFieldControl]
            }] } });
//# sourceMappingURL=data:application/json;base64,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